/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.transforms;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.transforms.SimilarityTransform;

public final class CaseAmplification
implements SimilarityTransform {
    private final double factor;

    public CaseAmplification(double factor) {
        Preconditions.checkArgument((factor != 0.0 && !Double.isNaN(factor) ? 1 : 0) != 0, (Object)"factor is 0 or NaN");
        this.factor = factor;
    }

    @Override
    public double transformSimilarity(long id1, long id2, double value) {
        return value < 0.0 ? -Math.pow(-value, this.factor) : Math.pow(value, this.factor);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    public String toString() {
        return "CaseAmplification[factor:" + this.factor + ']';
    }
}

