/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.similarity.AbstractItemSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class TanimotoCoefficientSimilarity
extends AbstractItemSimilarity
implements UserSimilarity {
    public TanimotoCoefficientSimilarity(DataModel dataModel) {
        super(dataModel);
    }

    @Override
    public void setPreferenceInferrer(PreferenceInferrer inferrer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double userSimilarity(long userID1, long userID2) throws TasteException {
        DataModel dataModel = this.getDataModel();
        FastIDSet xPrefs = dataModel.getItemIDsFromUser(userID1);
        FastIDSet yPrefs = dataModel.getItemIDsFromUser(userID2);
        if (xPrefs.isEmpty() && yPrefs.isEmpty()) {
            return Double.NaN;
        }
        if (xPrefs.isEmpty() || yPrefs.isEmpty()) {
            return 0.0;
        }
        int intersectionSize = xPrefs.intersectionSize(yPrefs);
        if (intersectionSize == 0) {
            return Double.NaN;
        }
        int unionSize = xPrefs.size() + yPrefs.size() - intersectionSize;
        return (double)intersectionSize / (double)unionSize;
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        int preferring1 = this.getDataModel().getNumUsersWithPreferenceFor(itemID1);
        return this.doItemSimilarity(itemID1, itemID2, preferring1);
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        int preferring1 = this.getDataModel().getNumUsersWithPreferenceFor(itemID1);
        int length = itemID2s.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.doItemSimilarity(itemID1, itemID2s[i], preferring1);
        }
        return result;
    }

    private double doItemSimilarity(long itemID1, long itemID2, int preferring1) throws TasteException {
        DataModel dataModel = this.getDataModel();
        int preferring1and2 = dataModel.getNumUsersWithPreferenceFor(itemID1, itemID2);
        int preferring2 = dataModel.getNumUsersWithPreferenceFor(itemID2);
        return (double)preferring1and2 / (double)(preferring1 + preferring2 - preferring1and2);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.getDataModel());
    }

    public String toString() {
        return "TanimotoCoefficientSimilarity[dataModel:" + this.getDataModel() + ']';
    }
}

