/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.apache.mahout.common.RandomUtils;

public final class GenericUserSimilarity
implements UserSimilarity {
    private final FastByIDMap<FastByIDMap<Double>> similarityMaps = new FastByIDMap();

    public GenericUserSimilarity(Iterable<UserUserSimilarity> similarities) {
        this.initSimilarityMaps(similarities.iterator());
    }

    public GenericUserSimilarity(Iterable<UserUserSimilarity> similarities, int maxToKeep) {
        List<UserUserSimilarity> keptSimilarities = TopItems.getTopUserUserSimilarities(maxToKeep, similarities.iterator());
        this.initSimilarityMaps(keptSimilarities.iterator());
    }

    public GenericUserSimilarity(UserSimilarity otherSimilarity, DataModel dataModel) throws TasteException {
        long[] userIDs = GenericUserSimilarity.longIteratorToList(dataModel.getUserIDs());
        this.initSimilarityMaps((Iterator<UserUserSimilarity>)((Object)new DataModelSimilaritiesIterator(otherSimilarity, userIDs)));
    }

    public GenericUserSimilarity(UserSimilarity otherSimilarity, DataModel dataModel, int maxToKeep) throws TasteException {
        long[] userIDs = GenericUserSimilarity.longIteratorToList(dataModel.getUserIDs());
        DataModelSimilaritiesIterator it = new DataModelSimilaritiesIterator(otherSimilarity, userIDs);
        List<UserUserSimilarity> keptSimilarities = TopItems.getTopUserUserSimilarities(maxToKeep, (Iterator<UserUserSimilarity>)((Object)it));
        this.initSimilarityMaps(keptSimilarities.iterator());
    }

    static long[] longIteratorToList(LongPrimitiveIterator iterator) {
        long[] newResult;
        long[] result = new long[5];
        int size = 0;
        while (iterator.hasNext()) {
            if (size == result.length) {
                newResult = new long[result.length << 1];
                System.arraycopy(result, 0, newResult, 0, result.length);
                result = newResult;
            }
            result[size++] = (Long)iterator.next();
        }
        if (size != result.length) {
            newResult = new long[size];
            System.arraycopy(result, 0, newResult, 0, size);
            result = newResult;
        }
        return result;
    }

    private void initSimilarityMaps(Iterator<UserUserSimilarity> similarities) {
        while (similarities.hasNext()) {
            long user2;
            long user1;
            long similarityUser2;
            UserUserSimilarity uuc = similarities.next();
            long similarityUser1 = uuc.getUserID1();
            if (similarityUser1 == (similarityUser2 = uuc.getUserID2())) continue;
            if (similarityUser1 < similarityUser2) {
                user1 = similarityUser1;
                user2 = similarityUser2;
            } else {
                user1 = similarityUser2;
                user2 = similarityUser1;
            }
            FastByIDMap<Double> map = this.similarityMaps.get(user1);
            if (map == null) {
                map = new FastByIDMap();
                this.similarityMaps.put(user1, map);
            }
            map.put(user2, uuc.getValue());
        }
    }

    @Override
    public double userSimilarity(long userID1, long userID2) {
        long second;
        long first;
        if (userID1 == userID2) {
            return 1.0;
        }
        if (userID1 < userID2) {
            first = userID1;
            second = userID2;
        } else {
            first = userID2;
            second = userID1;
        }
        FastByIDMap<Double> nextMap = this.similarityMaps.get(first);
        if (nextMap == null) {
            return Double.NaN;
        }
        Double similarity = nextMap.get(second);
        return similarity == null ? Double.NaN : similarity;
    }

    @Override
    public void setPreferenceInferrer(PreferenceInferrer inferrer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    private static final class DataModelSimilaritiesIterator
    extends AbstractIterator<UserUserSimilarity> {
        private final UserSimilarity otherSimilarity;
        private final long[] itemIDs;
        private int i;
        private long itemID1;
        private int j;

        private DataModelSimilaritiesIterator(UserSimilarity otherSimilarity, long[] itemIDs) {
            this.otherSimilarity = otherSimilarity;
            this.itemIDs = itemIDs;
            this.i = 0;
            this.itemID1 = itemIDs[0];
            this.j = 1;
        }

        protected UserUserSimilarity computeNext() {
            int size = this.itemIDs.length;
            while (this.i < size - 1) {
                double similarity;
                long itemID2 = this.itemIDs[this.j];
                try {
                    similarity = this.otherSimilarity.userSimilarity(this.itemID1, itemID2);
                }
                catch (TasteException te) {
                    throw new IllegalStateException(te);
                }
                if (!Double.isNaN(similarity)) {
                    return new UserUserSimilarity(this.itemID1, itemID2, similarity);
                }
                if (++this.j != size) continue;
                this.itemID1 = this.itemIDs[++this.i];
                this.j = this.i + 1;
            }
            return (UserUserSimilarity)this.endOfData();
        }
    }

    public static final class UserUserSimilarity
    implements Comparable<UserUserSimilarity> {
        private final long userID1;
        private final long userID2;
        private final double value;

        public UserUserSimilarity(long userID1, long userID2, double value) {
            Preconditions.checkArgument((value >= -1.0 && value <= 1.0 ? 1 : 0) != 0, (String)"Illegal value: %s", (Object[])new Object[]{value});
            this.userID1 = userID1;
            this.userID2 = userID2;
            this.value = value;
        }

        public long getUserID1() {
            return this.userID1;
        }

        public long getUserID2() {
            return this.userID2;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return "UserUserSimilarity[" + this.userID1 + ',' + this.userID2 + ':' + this.value + ']';
        }

        @Override
        public int compareTo(UserUserSimilarity other) {
            double otherValue = other.getValue();
            return this.value > otherValue ? -1 : (this.value < otherValue ? 1 : 0);
        }

        public boolean equals(Object other) {
            if (!(other instanceof UserUserSimilarity)) {
                return false;
            }
            UserUserSimilarity otherSimilarity = (UserUserSimilarity)other;
            return otherSimilarity.getUserID1() == this.userID1 && otherSimilarity.getUserID2() == this.userID2 && otherSimilarity.getValue() == this.value;
        }

        public int hashCode() {
            return (int)this.userID1 ^ (int)this.userID2 ^ RandomUtils.hashDouble((double)this.value);
        }
    }
}

