/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.slopeone.jdbc;

import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.jdbc.AbstractJDBCDataModel;
import org.apache.mahout.cf.taste.impl.recommender.slopeone.jdbc.AbstractJDBCDiffStorage;

public final class MySQLJDBCDiffStorage
extends AbstractJDBCDiffStorage {
    private static final int DEFAULT_MIN_DIFF_COUNT = 2;

    public MySQLJDBCDiffStorage(AbstractJDBCDataModel dataModel) throws TasteException {
        this(dataModel, "taste_slopeone_diffs", "item_id_a", "item_id_b", "count", "average_diff", "standard_deviation", 2);
    }

    public MySQLJDBCDiffStorage(AbstractJDBCDataModel dataModel, String diffsTable, String itemIDAColumn, String itemIDBColumn, String countColumn, String avgColumn, String stdevColumn, int minDiffCount) throws TasteException {
        super(dataModel, "SELECT " + countColumn + ", " + avgColumn + ", " + stdevColumn + " FROM " + diffsTable + " WHERE " + itemIDAColumn + "=? AND " + itemIDBColumn + "=?", "SELECT " + countColumn + ", " + avgColumn + ", " + stdevColumn + ", " + itemIDAColumn + " FROM " + diffsTable + ", " + dataModel.getPreferenceTable() + " WHERE " + itemIDBColumn + "=? AND " + itemIDAColumn + " = " + dataModel.getItemIDColumn() + " AND " + dataModel.getUserIDColumn() + "=? ORDER BY " + itemIDAColumn + " UNION " + "SELECT " + countColumn + ", -" + avgColumn + ", " + stdevColumn + ", " + itemIDBColumn + " FROM " + diffsTable + ", " + dataModel.getPreferenceTable() + " WHERE " + itemIDAColumn + "=? AND " + itemIDBColumn + " = " + dataModel.getItemIDColumn() + " AND " + dataModel.getUserIDColumn() + "=? ORDER BY " + itemIDBColumn, "SELECT COUNT(1), AVG(" + dataModel.getPreferenceColumn() + ") FROM " + dataModel.getPreferenceTable() + " WHERE " + dataModel.getItemIDColumn() + "=?", "SELECT diffs." + countColumn + ", diffs." + avgColumn + ", diffs." + itemIDAColumn + ", diffs." + itemIDBColumn + ", prefs." + dataModel.getPreferenceColumn() + " FROM " + diffsTable + " AS diffs, " + dataModel.getPreferenceTable() + " AS prefs WHERE prefs." + dataModel.getUserIDColumn() + "=? AND (prefs." + dataModel.getItemIDColumn() + " = diffs." + itemIDAColumn + " OR prefs." + dataModel.getItemIDColumn() + " = diffs." + itemIDBColumn + ')', new String[]{"UPDATE " + diffsTable + " SET " + avgColumn + " = " + avgColumn + " - (? / " + countColumn + ") WHERE " + itemIDAColumn + "=?", "UPDATE " + diffsTable + " SET " + avgColumn + " = " + avgColumn + " + (? / " + countColumn + ") WHERE " + itemIDBColumn + "=?"}, "UPDATE " + diffsTable + " SET " + countColumn + "=?, " + avgColumn + "=? WHERE " + itemIDAColumn + "=? AND " + itemIDBColumn + "=?", "INSERT INTO " + diffsTable + " (" + itemIDAColumn + ", " + itemIDBColumn + ", " + avgColumn + ", " + stdevColumn + ", " + countColumn + ") VALUES (?,?,?,0,1)", "DELETE FROM " + diffsTable + " WHERE " + itemIDAColumn + "=? AND " + itemIDBColumn + "=?", "SELECT id FROM (SELECT " + itemIDAColumn + " AS id FROM " + diffsTable + ", " + dataModel.getPreferenceTable() + " WHERE " + itemIDBColumn + " = " + dataModel.getItemIDColumn() + " AND " + dataModel.getUserIDColumn() + "=? UNION DISTINCT" + " SELECT " + itemIDBColumn + " AS id FROM " + diffsTable + ", " + dataModel.getPreferenceTable() + " WHERE " + itemIDAColumn + " = " + dataModel.getItemIDColumn() + " AND " + dataModel.getUserIDColumn() + "=?) " + "possible_item_ids WHERE id NOT IN (SELECT " + dataModel.getItemIDColumn() + " FROM " + dataModel.getPreferenceTable() + " WHERE " + dataModel.getUserIDColumn() + "=?)", "TRUNCATE " + diffsTable, "INSERT INTO " + diffsTable + " (" + itemIDAColumn + ", " + itemIDBColumn + ", " + avgColumn + ", " + stdevColumn + ", " + countColumn + ") SELECT prefsA." + dataModel.getItemIDColumn() + ", prefsB." + dataModel.getItemIDColumn() + ", AVG(prefsB." + dataModel.getPreferenceColumn() + " - prefsA." + dataModel.getPreferenceColumn() + "), STDDEV_POP(prefsB." + dataModel.getPreferenceColumn() + " - prefsA." + dataModel.getPreferenceColumn() + "), COUNT(1) AS count FROM " + dataModel.getPreferenceTable() + " prefsA, " + dataModel.getPreferenceTable() + " prefsB WHERE prefsA." + dataModel.getUserIDColumn() + " = prefsB." + dataModel.getUserIDColumn() + " AND prefsA." + dataModel.getItemIDColumn() + " < prefsB." + dataModel.getItemIDColumn() + ' ' + " GROUP BY prefsA." + dataModel.getItemIDColumn() + ", prefsB." + dataModel.getItemIDColumn() + " HAVING count >= ?", "SELECT COUNT(1) FROM " + diffsTable, minDiffCount);
    }

    @Override
    protected int getFetchSize() {
        return Integer.MIN_VALUE;
    }
}

