/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.slopeone.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.slopeone.DiffStorage;
import org.apache.mahout.common.iterator.FileLineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileDiffStorage
implements DiffStorage {
    private static final Logger log = LoggerFactory.getLogger(FileDiffStorage.class);
    private static final long MIN_RELOAD_INTERVAL_MS = 60000L;
    private static final char COMMENT_CHAR = '#';
    private final File dataFile;
    private long lastModified;
    private final long maxEntries;
    private final FastByIDMap<FastByIDMap<RunningAverage>> averageDiffs;
    private final FastIDSet allRecommendableItemIDs;
    private final ReadWriteLock buildAverageDiffsLock;

    public FileDiffStorage(File dataFile, long maxEntries) throws FileNotFoundException {
        Preconditions.checkArgument((dataFile != null ? 1 : 0) != 0, (Object)"dataFile is null");
        if (!dataFile.exists() || dataFile.isDirectory()) {
            throw new FileNotFoundException(dataFile.toString());
        }
        Preconditions.checkArgument((maxEntries > 0L ? 1 : 0) != 0, (Object)"maxEntries must be positive");
        log.info("Creating FileDataModel for file {}", (Object)dataFile);
        this.dataFile = dataFile.getAbsoluteFile();
        this.lastModified = dataFile.lastModified();
        this.maxEntries = maxEntries;
        this.averageDiffs = new FastByIDMap();
        this.allRecommendableItemIDs = new FastIDSet();
        this.buildAverageDiffsLock = new ReentrantReadWriteLock();
        this.buildDiffs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDiffs() {
        if (this.buildAverageDiffsLock.writeLock().tryLock()) {
            try {
                this.averageDiffs.clear();
                this.allRecommendableItemIDs.clear();
                FileLineIterator iterator = new FileLineIterator(this.dataFile, false);
                String firstLine = (String)iterator.peek();
                while (firstLine.length() == 0 || firstLine.charAt(0) == '#') {
                    iterator.next();
                    firstLine = (String)iterator.peek();
                }
                char delimiter = FileDataModel.determineDelimiter(firstLine);
                long averageCount = 0L;
                while (iterator.hasNext()) {
                    averageCount = this.processLine((String)iterator.next(), delimiter, averageCount);
                }
                this.pruneInconsequentialDiffs();
                this.updateAllRecommendableItems();
            }
            catch (IOException ioe) {
                log.warn("Exception while reloading", (Throwable)ioe);
            }
            finally {
                this.buildAverageDiffsLock.writeLock().unlock();
            }
        }
    }

    private long processLine(String line, char delimiter, long averageCount) {
        RunningAverage average;
        FastByIDMap<RunningAverage> level1Map;
        if (line.length() == 0 || line.charAt(0) == '#') {
            return averageCount;
        }
        int delimiterOne = line.indexOf(delimiter);
        Preconditions.checkArgument((delimiterOne >= 0 ? 1 : 0) != 0, (String)"Bad line: %s", (Object[])new Object[]{line});
        int delimiterTwo = line.indexOf(delimiter, delimiterOne + 1);
        Preconditions.checkArgument((delimiterTwo >= 0 ? 1 : 0) != 0, (String)"Bad line: %s", (Object[])new Object[]{line});
        long itemID1 = Long.parseLong(line.substring(0, delimiterOne));
        long itemID2 = Long.parseLong(line.substring(delimiterOne + 1, delimiterTwo));
        double diff = Double.parseDouble(line.substring(delimiterTwo + 1));
        if (itemID1 > itemID2) {
            long temp = itemID1;
            itemID1 = itemID2;
            itemID2 = temp;
        }
        if ((level1Map = this.averageDiffs.get(itemID1)) == null) {
            level1Map = new FastByIDMap();
            this.averageDiffs.put(itemID1, level1Map);
        }
        if ((average = level1Map.get(itemID2)) == null && averageCount < this.maxEntries) {
            average = new FullRunningAverage();
            level1Map.put(itemID2, average);
            ++averageCount;
        }
        if (average != null) {
            average.addDatum(diff);
        }
        this.allRecommendableItemIDs.add(itemID1);
        this.allRecommendableItemIDs.add(itemID2);
        return averageCount;
    }

    private void pruneInconsequentialDiffs() {
        Iterator<Map.Entry<Long, FastByIDMap<RunningAverage>>> it1 = this.averageDiffs.entrySet().iterator();
        while (it1.hasNext()) {
            FastByIDMap<RunningAverage> map = it1.next().getValue();
            Iterator<Map.Entry<Long, RunningAverage>> it2 = map.entrySet().iterator();
            while (it2.hasNext()) {
                RunningAverage average = it2.next().getValue();
                if (average.getCount() > 1) continue;
                it2.remove();
            }
            if (map.isEmpty()) {
                it1.remove();
                continue;
            }
            map.rehash();
        }
        this.averageDiffs.rehash();
    }

    private void updateAllRecommendableItems() {
        for (Map.Entry<Long, FastByIDMap<RunningAverage>> entry : this.averageDiffs.entrySet()) {
            this.allRecommendableItemIDs.add(entry.getKey());
            LongPrimitiveIterator it = entry.getValue().keySetIterator();
            while (it.hasNext()) {
                this.allRecommendableItemIDs.add((Long)it.next());
            }
        }
        this.allRecommendableItemIDs.rehash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningAverage getDiff(long itemID1, long itemID2) {
        FastByIDMap<RunningAverage> level2Map;
        boolean inverted = false;
        if (itemID1 > itemID2) {
            inverted = true;
            long temp = itemID1;
            itemID1 = itemID2;
            itemID2 = temp;
        }
        try {
            this.buildAverageDiffsLock.readLock().lock();
            level2Map = this.averageDiffs.get(itemID1);
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
        RunningAverage average = null;
        if (level2Map != null) {
            average = level2Map.get(itemID2);
        }
        if (inverted) {
            if (average == null) {
                return null;
            }
            return new InvertedRunningAverage(average);
        }
        return average;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningAverage[] getDiffs(long userID, long itemID, PreferenceArray prefs) {
        try {
            this.buildAverageDiffsLock.readLock().lock();
            int size = prefs.length();
            RunningAverage[] result = new RunningAverage[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.getDiff(prefs.getItemID(i), itemID);
            }
            RunningAverage[] runningAverageArray = result;
            return runningAverageArray;
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
    }

    @Override
    public RunningAverage getAverageItemPref(long itemID) {
        return null;
    }

    @Override
    public void addItemPref(long userID, long itemIDA, float prefValue) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateItemPref(long itemID, float prefDelta) {
        try {
            this.buildAverageDiffsLock.readLock().lock();
            for (Map.Entry<Long, FastByIDMap<RunningAverage>> entry : this.averageDiffs.entrySet()) {
                boolean matchesItemID1 = itemID == entry.getKey();
                for (Map.Entry<Long, RunningAverage> entry2 : entry.getValue().entrySet()) {
                    RunningAverage average = entry2.getValue();
                    if (matchesItemID1) {
                        average.changeDatum(-prefDelta);
                        continue;
                    }
                    if (itemID != entry2.getKey()) continue;
                    average.changeDatum(prefDelta);
                }
            }
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
    }

    @Override
    public void removeItemPref(long userID, long itemIDA, float prefValue) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastIDSet getRecommendableItemIDs(long userID) {
        try {
            this.buildAverageDiffsLock.readLock().lock();
            FastIDSet fastIDSet = this.allRecommendableItemIDs.clone();
            return fastIDSet;
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        long mostRecentModification = this.dataFile.lastModified();
        if (mostRecentModification > this.lastModified + 60000L) {
            log.debug("File has changed; reloading...");
            this.lastModified = mostRecentModification;
            this.buildDiffs();
        }
    }
}

