/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.slopeone;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.common.Weighting;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.slopeone.DiffStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryDiffStorage
implements DiffStorage {
    private static final Logger log = LoggerFactory.getLogger(MemoryDiffStorage.class);
    private final DataModel dataModel;
    private final boolean stdDevWeighted;
    private final long maxEntries;
    private final FastByIDMap<FastByIDMap<RunningAverage>> averageDiffs;
    private final FastByIDMap<RunningAverage> averageItemPref;
    private final FastIDSet allRecommendableItemIDs;
    private final ReadWriteLock buildAverageDiffsLock;
    private final RefreshHelper refreshHelper;

    public MemoryDiffStorage(DataModel dataModel, Weighting stdDevWeighted, long maxEntries) throws TasteException {
        Preconditions.checkArgument((dataModel != null ? 1 : 0) != 0, (Object)"dataModel is null");
        Preconditions.checkArgument((dataModel.getNumItems() >= 1 ? 1 : 0) != 0, (Object)"dataModel has no items");
        Preconditions.checkArgument((maxEntries > 0L ? 1 : 0) != 0, (Object)"maxEntries must be positive");
        this.dataModel = dataModel;
        this.stdDevWeighted = stdDevWeighted == Weighting.WEIGHTED;
        this.maxEntries = maxEntries;
        this.averageDiffs = new FastByIDMap();
        this.averageItemPref = new FastByIDMap();
        this.buildAverageDiffsLock = new ReentrantReadWriteLock();
        this.allRecommendableItemIDs = new FastIDSet(dataModel.getNumItems());
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                MemoryDiffStorage.this.buildAverageDiffs();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.buildAverageDiffs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningAverage getDiff(long itemID1, long itemID2) {
        FastByIDMap<RunningAverage> level2Map;
        boolean inverted = false;
        if (itemID1 > itemID2) {
            inverted = true;
            long temp = itemID1;
            itemID1 = itemID2;
            itemID2 = temp;
        }
        try {
            this.buildAverageDiffsLock.readLock().lock();
            level2Map = this.averageDiffs.get(itemID1);
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
        RunningAverage average = null;
        if (level2Map != null) {
            average = level2Map.get(itemID2);
        }
        if (inverted) {
            if (average == null) {
                return null;
            }
            return this.stdDevWeighted ? new InvertedRunningAverageAndStdDev((RunningAverageAndStdDev)average) : new InvertedRunningAverage(average);
        }
        return average;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningAverage[] getDiffs(long userID, long itemID, PreferenceArray prefs) {
        try {
            this.buildAverageDiffsLock.readLock().lock();
            int size = prefs.length();
            RunningAverage[] result = new RunningAverage[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.getDiff(prefs.getItemID(i), itemID);
            }
            RunningAverage[] runningAverageArray = result;
            return runningAverageArray;
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
    }

    @Override
    public RunningAverage getAverageItemPref(long itemID) {
        return this.averageItemPref.get(itemID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItemPref(long userID, long itemIDA, float prefValue) throws TasteException {
        PreferenceArray userPreferences = this.dataModel.getPreferencesFromUser(userID);
        try {
            this.buildAverageDiffsLock.writeLock().lock();
            FastByIDMap<RunningAverage> aMap = this.averageDiffs.get(itemIDA);
            if (aMap == null) {
                aMap = new FastByIDMap();
                this.averageDiffs.put(itemIDA, aMap);
            }
            int length = userPreferences.length();
            for (int i = 0; i < length; ++i) {
                RunningAverage average;
                long itemIDB = userPreferences.getItemID(i);
                float bValue = userPreferences.getValue(i);
                if (itemIDA < itemIDB) {
                    RunningAverage average2 = aMap.get(itemIDB);
                    if (average2 == null) {
                        average2 = this.buildRunningAverage();
                        aMap.put(itemIDB, average2);
                    }
                    average2.addDatum(bValue - prefValue);
                    continue;
                }
                FastByIDMap<RunningAverage> bMap = this.averageDiffs.get(itemIDB);
                if (bMap == null) {
                    bMap = new FastByIDMap();
                    this.averageDiffs.put(itemIDB, bMap);
                }
                if ((average = bMap.get(itemIDA)) == null) {
                    average = this.buildRunningAverage();
                    bMap.put(itemIDA, average);
                }
                average.addDatum(prefValue - bValue);
            }
        }
        finally {
            this.buildAverageDiffsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateItemPref(long itemID, float prefDelta) {
        if (this.stdDevWeighted) {
            throw new UnsupportedOperationException("Can't update only when stdDevWeighted is set");
        }
        try {
            this.buildAverageDiffsLock.readLock().lock();
            for (Map.Entry<Long, FastByIDMap<RunningAverage>> entry : this.averageDiffs.entrySet()) {
                boolean matchesItemID1 = itemID == entry.getKey();
                for (Map.Entry<Long, RunningAverage> entry2 : entry.getValue().entrySet()) {
                    RunningAverage average = entry2.getValue();
                    if (matchesItemID1) {
                        average.changeDatum(-prefDelta);
                        continue;
                    }
                    if (itemID != entry2.getKey()) continue;
                    average.changeDatum(prefDelta);
                }
            }
            RunningAverage itemAverage = this.averageItemPref.get(itemID);
            if (itemAverage != null) {
                itemAverage.changeDatum(prefDelta);
            }
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItemPref(long userID, long itemIDA, float prefValue) throws TasteException {
        PreferenceArray userPreferences = this.dataModel.getPreferencesFromUser(userID);
        try {
            this.buildAverageDiffsLock.writeLock().lock();
            FastByIDMap<RunningAverage> aMap = this.averageDiffs.get(itemIDA);
            int length = userPreferences.length();
            for (int i = 0; i < length; ++i) {
                RunningAverage average;
                FastByIDMap<RunningAverage> bMap;
                long itemIDB = userPreferences.getItemID(i);
                float bValue = userPreferences.getValue(i);
                if (itemIDA < itemIDB) {
                    RunningAverage average2;
                    if (aMap == null || (average2 = aMap.get(itemIDB)) == null) continue;
                    if (average2.getCount() <= 1) {
                        aMap.remove(itemIDB);
                        continue;
                    }
                    average2.removeDatum(bValue - prefValue);
                    continue;
                }
                if (itemIDA <= itemIDB || (bMap = this.averageDiffs.get(itemIDB)) == null || (average = bMap.get(itemIDA)) == null) continue;
                if (average.getCount() <= 1) {
                    aMap.remove(itemIDA);
                    continue;
                }
                average.removeDatum(prefValue - bValue);
            }
        }
        finally {
            this.buildAverageDiffsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FastIDSet getRecommendableItemIDs(long userID) throws TasteException {
        FastIDSet result;
        try {
            this.buildAverageDiffsLock.readLock().lock();
            result = this.allRecommendableItemIDs.clone();
        }
        finally {
            this.buildAverageDiffsLock.readLock().unlock();
        }
        LongPrimitiveIterator it = result.iterator();
        while (it.hasNext()) {
            if (this.dataModel.getPreferenceValue(userID, (Long)it.next()) == null) continue;
            it.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAverageDiffs() throws TasteException {
        log.info("Building average diffs...");
        try {
            this.buildAverageDiffsLock.writeLock().lock();
            this.averageDiffs.clear();
            long averageCount = 0L;
            LongPrimitiveIterator it = this.dataModel.getUserIDs();
            while (it.hasNext()) {
                averageCount = this.processOneUser(averageCount, it.nextLong());
            }
            this.pruneInconsequentialDiffs();
            this.updateAllRecommendableItems();
        }
        finally {
            this.buildAverageDiffsLock.writeLock().unlock();
        }
    }

    private void pruneInconsequentialDiffs() {
        Iterator<Map.Entry<Long, FastByIDMap<RunningAverage>>> it1 = this.averageDiffs.entrySet().iterator();
        while (it1.hasNext()) {
            FastByIDMap<RunningAverage> map = it1.next().getValue();
            Iterator<Map.Entry<Long, RunningAverage>> it2 = map.entrySet().iterator();
            while (it2.hasNext()) {
                RunningAverage average = it2.next().getValue();
                if (average.getCount() > 1) continue;
                it2.remove();
            }
            if (map.isEmpty()) {
                it1.remove();
                continue;
            }
            map.rehash();
        }
        this.averageDiffs.rehash();
    }

    private void updateAllRecommendableItems() throws TasteException {
        FastIDSet ids = new FastIDSet(this.dataModel.getNumItems());
        for (Map.Entry<Long, FastByIDMap<RunningAverage>> entry : this.averageDiffs.entrySet()) {
            ids.add(entry.getKey());
            LongPrimitiveIterator it = entry.getValue().keySetIterator();
            while (it.hasNext()) {
                ids.add((Long)it.next());
            }
        }
        this.allRecommendableItemIDs.clear();
        this.allRecommendableItemIDs.addAll(ids);
        this.allRecommendableItemIDs.rehash();
    }

    private long processOneUser(long averageCount, long userID) throws TasteException {
        log.debug("Processing prefs for user {}", (Object)userID);
        PreferenceArray userPreferences = this.dataModel.getPreferencesFromUser(userID);
        int length = userPreferences.length();
        for (int i = 0; i < length - 1; ++i) {
            float prefAValue = userPreferences.getValue(i);
            long itemIDA = userPreferences.getItemID(i);
            FastByIDMap<RunningAverage> aMap = this.averageDiffs.get(itemIDA);
            if (aMap == null) {
                aMap = new FastByIDMap();
                this.averageDiffs.put(itemIDA, aMap);
            }
            for (int j = i + 1; j < length; ++j) {
                long itemIDB = userPreferences.getItemID(j);
                RunningAverage average = aMap.get(itemIDB);
                if (average == null && averageCount < this.maxEntries) {
                    average = this.buildRunningAverage();
                    aMap.put(itemIDB, average);
                    ++averageCount;
                }
                if (average == null) continue;
                average.addDatum(userPreferences.getValue(j) - prefAValue);
            }
            RunningAverage itemAverage = this.averageItemPref.get(itemIDA);
            if (itemAverage == null) {
                itemAverage = this.buildRunningAverage();
                this.averageItemPref.put(itemIDA, itemAverage);
            }
            itemAverage.addDatum(prefAValue);
        }
        return averageCount;
    }

    private RunningAverage buildRunningAverage() {
        return this.stdDevWeighted ? new FullRunningAverageAndStdDev() : new FullRunningAverage();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "MemoryDiffStorage";
    }
}

