/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.knn;

import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.impl.recommender.knn.Optimizer;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.MostSimilarItemsCandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.LongPair;

public final class KnnItemBasedRecommender
extends GenericItemBasedRecommender {
    private final Optimizer optimizer;
    private final int neighborhoodSize;

    public KnnItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity, Optimizer optimizer, CandidateItemsStrategy candidateItemsStrategy, MostSimilarItemsCandidateItemsStrategy mostSimilarItemsCandidateItemsStrategy, int neighborhoodSize) {
        super(dataModel, similarity, candidateItemsStrategy, mostSimilarItemsCandidateItemsStrategy);
        this.optimizer = optimizer;
        this.neighborhoodSize = neighborhoodSize;
    }

    public KnnItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity, Optimizer optimizer, int neighborhoodSize) {
        this(dataModel, similarity, optimizer, KnnItemBasedRecommender.getDefaultCandidateItemsStrategy(), KnnItemBasedRecommender.getDefaultMostSimilarItemsCandidateItemsStrategy(), neighborhoodSize);
    }

    private List<RecommendedItem> mostSimilarItems(long itemID, LongPrimitiveIterator possibleItemIDs, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        GenericItemBasedRecommender.MostSimilarEstimator estimator = new GenericItemBasedRecommender.MostSimilarEstimator(itemID, this.getSimilarity(), rescorer);
        return TopItems.getTopItems(howMany, possibleItemIDs, null, estimator);
    }

    private double[] getInterpolations(long itemID, long userID, long[] itemNeighborhood) throws TasteException {
        int k = itemNeighborhood.length;
        double[][] aMatrix = new double[k][k];
        double[] b = new double[k];
        int i = 0;
        DataModel dataModel = this.getDataModel();
        int numUsers = this.getDataModel().getNumUsers();
        for (long iitem : itemNeighborhood) {
            PreferenceArray iPrefs = this.getDataModel().getPreferencesForItem(iitem);
            int iSize = iPrefs.length();
            int j = 0;
            for (long jitem : itemNeighborhood) {
                double value = 0.0;
                for (int pi = 0; pi < iSize; ++pi) {
                    Float pj;
                    long v = iPrefs.getUserID(pi);
                    if (v == userID || (pj = dataModel.getPreferenceValue(userID, jitem)) == null) continue;
                    value += (double)(iPrefs.getValue(pi) * pj.floatValue());
                }
                aMatrix[i][j] = value / (double)numUsers;
                ++j;
            }
            ++i;
        }
        PreferenceArray iPrefs = this.getDataModel().getPreferencesForItem(itemID);
        int iSize = iPrefs.length();
        i = 0;
        for (long jitem : itemNeighborhood) {
            double value = 0.0;
            for (int pi = 0; pi < iSize; ++pi) {
                Float pj;
                long v = iPrefs.getUserID(pi);
                if (v == userID || (pj = dataModel.getPreferenceValue(userID, jitem)) == null) continue;
                value += (double)(iPrefs.getValue(pi) * pj.floatValue());
            }
            b[i] = value / (double)numUsers;
            ++i;
        }
        return this.optimizer.optimize(aMatrix, b);
    }

    @Override
    protected float doEstimatePreference(long theUserID, PreferenceArray preferencesFromUser, long itemID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        int size = preferencesFromUser.length();
        FastIDSet possibleItemIDs = new FastIDSet(size);
        for (int i = 0; i < size; ++i) {
            possibleItemIDs.add(preferencesFromUser.getItemID(i));
        }
        possibleItemIDs.remove(itemID);
        List<RecommendedItem> mostSimilar = this.mostSimilarItems(itemID, possibleItemIDs.iterator(), this.neighborhoodSize, null);
        long[] theNeighborhood = new long[mostSimilar.size()];
        int nOffset = 0;
        for (RecommendedItem rec : mostSimilar) {
            theNeighborhood[nOffset++] = rec.getItemID();
        }
        double[] weights = this.getInterpolations(itemID, theUserID, theNeighborhood);
        int i = 0;
        double preference = 0.0;
        double totalSimilarity = 0.0;
        for (long jitem : theNeighborhood) {
            Float pref = dataModel.getPreferenceValue(theUserID, jitem);
            if (pref != null) {
                preference += (double)pref.floatValue() * weights[i];
                totalSimilarity += weights[i];
            }
            ++i;
        }
        return totalSimilarity == 0.0 ? Float.NaN : (float)(preference / totalSimilarity);
    }
}

