/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.ByRescoreComparator;
import org.apache.mahout.cf.taste.impl.recommender.ClusterSimilarity;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.ClusteringRecommender;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeClusteringRecommender
extends AbstractRecommender
implements ClusteringRecommender {
    private static final Logger log = LoggerFactory.getLogger(TreeClusteringRecommender.class);
    private static final FastIDSet[] NO_CLUSTERS = new FastIDSet[0];
    private static final Random RANDOM = RandomUtils.getRandom();
    private final ClusterSimilarity clusterSimilarity;
    private final int numClusters;
    private final double clusteringThreshold;
    private final boolean clusteringByThreshold;
    private final double samplingRate;
    private FastByIDMap<List<RecommendedItem>> topRecsByUserID;
    private FastIDSet[] allClusters;
    private FastByIDMap<FastIDSet> clustersByUserID;
    private final RefreshHelper refreshHelper;

    public TreeClusteringRecommender(DataModel dataModel, ClusterSimilarity clusterSimilarity, int numClusters) throws TasteException {
        this(dataModel, clusterSimilarity, numClusters, 1.0);
    }

    public TreeClusteringRecommender(DataModel dataModel, ClusterSimilarity clusterSimilarity, int numClusters, double samplingRate) throws TasteException {
        super(dataModel);
        Preconditions.checkArgument((clusterSimilarity != null ? 1 : 0) != 0, (Object)"clusterSimilarity is null");
        Preconditions.checkArgument((numClusters >= 2 ? 1 : 0) != 0, (Object)"numClusters must be at least 2");
        Preconditions.checkArgument((samplingRate > 0.0 && samplingRate <= 1.0 ? 1 : 0) != 0, (String)"samplingRate is invalid: %f", (Object[])new Object[]{samplingRate});
        this.clusterSimilarity = clusterSimilarity;
        this.numClusters = numClusters;
        this.clusteringThreshold = Double.NaN;
        this.clusteringByThreshold = false;
        this.samplingRate = samplingRate;
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                TreeClusteringRecommender.this.buildClusters();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.refreshHelper.addDependency(clusterSimilarity);
        this.buildClusters();
    }

    public TreeClusteringRecommender(DataModel dataModel, ClusterSimilarity clusterSimilarity, double clusteringThreshold) throws TasteException {
        this(dataModel, clusterSimilarity, clusteringThreshold, 1.0);
    }

    public TreeClusteringRecommender(DataModel dataModel, ClusterSimilarity clusterSimilarity, double clusteringThreshold, double samplingRate) throws TasteException {
        super(dataModel);
        Preconditions.checkArgument((clusterSimilarity != null ? 1 : 0) != 0, (Object)"clusterSimilarity is null");
        Preconditions.checkArgument((!Double.isNaN(clusteringThreshold) ? 1 : 0) != 0, (Object)"clusteringThreshold must not be NaN");
        Preconditions.checkArgument((samplingRate > 0.0 && samplingRate <= 1.0 ? 1 : 0) != 0, (String)"samplingRate is invalid: %f", (Object[])new Object[]{samplingRate});
        this.clusterSimilarity = clusterSimilarity;
        this.numClusters = Integer.MIN_VALUE;
        this.clusteringThreshold = clusteringThreshold;
        this.clusteringByThreshold = true;
        this.samplingRate = samplingRate;
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                TreeClusteringRecommender.this.buildClusters();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.refreshHelper.addDependency(clusterSimilarity);
        this.buildClusters();
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument((howMany >= 1 ? 1 : 0) != 0, (Object)"howMany must be at least 1");
        this.buildClusters();
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        List<RecommendedItem> recommended = this.topRecsByUserID.get(userID);
        if (recommended == null) {
            return Collections.emptyList();
        }
        DataModel dataModel = this.getDataModel();
        ArrayList<RecommendedItem> rescored = new ArrayList<RecommendedItem>(recommended.size());
        for (RecommendedItem recommendedItem : recommended) {
            long itemID = recommendedItem.getItemID();
            if (rescorer != null && rescorer.isFiltered(itemID) || dataModel.getPreferenceValue(userID, itemID) != null || rescorer != null && Double.isNaN(rescorer.rescore(itemID, recommendedItem.getValue()))) continue;
            rescored.add(recommendedItem);
        }
        Collections.sort(rescored, new ByRescoreComparator(rescorer));
        return rescored;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        DataModel model = this.getDataModel();
        Float actualPref = model.getPreferenceValue(userID, itemID);
        if (actualPref != null) {
            return actualPref.floatValue();
        }
        this.buildClusters();
        List<RecommendedItem> topRecsForUser = this.topRecsByUserID.get(userID);
        if (topRecsForUser != null) {
            for (RecommendedItem item : topRecsForUser) {
                if (itemID != item.getItemID()) continue;
                return item.getValue();
            }
        }
        return Float.NaN;
    }

    @Override
    public FastIDSet getCluster(long userID) throws TasteException {
        this.buildClusters();
        FastIDSet cluster = this.clustersByUserID.get(userID);
        return cluster == null ? new FastIDSet() : cluster;
    }

    @Override
    public FastIDSet[] getClusters() throws TasteException {
        this.buildClusters();
        return this.allClusters;
    }

    private void buildClusters() throws TasteException {
        DataModel model = this.getDataModel();
        int numUsers = model.getNumUsers();
        if (numUsers > 0) {
            ArrayList<FastIDSet> newClusters = new ArrayList<FastIDSet>(numUsers);
            LongPrimitiveIterator it = model.getUserIDs();
            while (it.hasNext()) {
                FastIDSet newCluster = new FastIDSet();
                newCluster.add(it.nextLong());
                newClusters.add(newCluster);
            }
            if (numUsers > 1) {
                this.findClusters(newClusters);
            }
            this.topRecsByUserID = this.computeTopRecsPerUserID(newClusters);
            this.clustersByUserID = TreeClusteringRecommender.computeClustersPerUserID(newClusters);
            this.allClusters = newClusters.toArray(new FastIDSet[newClusters.size()]);
        } else {
            this.topRecsByUserID = new FastByIDMap();
            this.clustersByUserID = new FastByIDMap();
            this.allClusters = NO_CLUSTERS;
        }
    }

    private void findClusters(List<FastIDSet> newClusters) throws TasteException {
        if (this.clusteringByThreshold) {
            Pair<FastIDSet, FastIDSet> nearestPair = this.findNearestClusters(newClusters);
            if (nearestPair != null) {
                FastIDSet cluster1 = nearestPair.getFirst();
                FastIDSet cluster2 = nearestPair.getSecond();
                while (this.clusterSimilarity.getSimilarity(cluster1, cluster2) >= this.clusteringThreshold) {
                    newClusters.remove(cluster1);
                    newClusters.remove(cluster2);
                    FastIDSet merged = new FastIDSet(cluster1.size() + cluster2.size());
                    merged.addAll(cluster1);
                    merged.addAll(cluster2);
                    newClusters.add(merged);
                    nearestPair = this.findNearestClusters(newClusters);
                    if (nearestPair != null) {
                        cluster1 = nearestPair.getFirst();
                        cluster2 = nearestPair.getSecond();
                        continue;
                    }
                    break;
                }
            }
        } else {
            Pair<FastIDSet, FastIDSet> nearestPair;
            while (newClusters.size() > this.numClusters && (nearestPair = this.findNearestClusters(newClusters)) != null) {
                FastIDSet cluster1 = nearestPair.getFirst();
                FastIDSet cluster2 = nearestPair.getSecond();
                newClusters.remove(cluster1);
                newClusters.remove(cluster2);
                FastIDSet merged = new FastIDSet(cluster1.size() + cluster2.size());
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                newClusters.add(merged);
            }
        }
    }

    private Pair<FastIDSet, FastIDSet> findNearestClusters(List<FastIDSet> clusters) throws TasteException {
        int size = clusters.size();
        Pair<FastIDSet, FastIDSet> nearestPair = null;
        double bestSimilarity = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            FastIDSet cluster1 = clusters.get(i);
            for (int j = i + 1; j < size; ++j) {
                FastIDSet cluster2;
                double similarity;
                if (!(this.samplingRate >= 1.0) && !(RANDOM.nextDouble() < this.samplingRate) || Double.isNaN(similarity = this.clusterSimilarity.getSimilarity(cluster1, cluster2 = clusters.get(j))) || !(similarity > bestSimilarity)) continue;
                bestSimilarity = similarity;
                nearestPair = new Pair<FastIDSet, FastIDSet>(cluster1, cluster2);
            }
        }
        return nearestPair;
    }

    private FastByIDMap<List<RecommendedItem>> computeTopRecsPerUserID(Iterable<FastIDSet> clusters) throws TasteException {
        FastByIDMap<List<RecommendedItem>> recsPerUser = new FastByIDMap<List<RecommendedItem>>();
        for (FastIDSet cluster : clusters) {
            List<RecommendedItem> recs = this.computeTopRecsForCluster(cluster);
            LongPrimitiveIterator it = cluster.iterator();
            while (it.hasNext()) {
                recsPerUser.put(it.nextLong(), recs);
            }
        }
        return recsPerUser;
    }

    private List<RecommendedItem> computeTopRecsForCluster(FastIDSet cluster) throws TasteException {
        DataModel dataModel = this.getDataModel();
        FastIDSet possibleItemIDs = new FastIDSet();
        LongPrimitiveIterator it = cluster.iterator();
        while (it.hasNext()) {
            possibleItemIDs.addAll(dataModel.getItemIDsFromUser(it.nextLong()));
        }
        Estimator estimator = new Estimator(cluster);
        List<RecommendedItem> topItems = TopItems.getTopItems(possibleItemIDs.size(), possibleItemIDs.iterator(), null, estimator);
        log.debug("Recommendations are: {}", topItems);
        return Collections.unmodifiableList(topItems);
    }

    private static FastByIDMap<FastIDSet> computeClustersPerUserID(Collection<FastIDSet> clusters) {
        FastByIDMap<FastIDSet> clustersPerUser = new FastByIDMap<FastIDSet>(clusters.size());
        for (FastIDSet cluster : clusters) {
            LongPrimitiveIterator it = cluster.iterator();
            while (it.hasNext()) {
                clustersPerUser.put(it.nextLong(), cluster);
            }
        }
        return clustersPerUser;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "TreeClusteringRecommender[clusterSimilarity:" + this.clusterSimilarity + ']';
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private final FastIDSet cluster;

        private Estimator(FastIDSet cluster) {
            this.cluster = cluster;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            DataModel dataModel = TreeClusteringRecommender.this.getDataModel();
            FullRunningAverage average = new FullRunningAverage();
            LongPrimitiveIterator it = this.cluster.iterator();
            while (it.hasNext()) {
                Float pref = dataModel.getPreferenceValue(it.nextLong(), itemID);
                if (pref == null) continue;
                average.addDatum(pref.floatValue());
            }
            return average.getAverage();
        }
    }
}

