/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.ByValueRecommendedItemComparator;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.impl.recommender.SimilarUser;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.GenericUserSimilarity;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class TopItems {
    private static final long[] NO_IDS = new long[0];

    private TopItems() {
    }

    public static List<RecommendedItem> getTopItems(int howMany, LongPrimitiveIterator possibleItemIDs, IDRescorer rescorer, Estimator<Long> estimator) throws TasteException {
        Preconditions.checkArgument((possibleItemIDs != null ? 1 : 0) != 0, (Object)"argument is null");
        Preconditions.checkArgument((estimator != null ? 1 : 0) != 0, (Object)"argument is null");
        PriorityQueue<RecommendedItem> topItems = new PriorityQueue<RecommendedItem>(howMany + 1, Collections.reverseOrder(ByValueRecommendedItemComparator.getInstance()));
        boolean full = false;
        double lowestTopValue = Double.NEGATIVE_INFINITY;
        while (possibleItemIDs.hasNext()) {
            double preference;
            long itemID = (Long)possibleItemIDs.next();
            if (rescorer != null && rescorer.isFiltered(itemID)) continue;
            try {
                preference = estimator.estimate(itemID);
            }
            catch (NoSuchItemException nsie) {
                continue;
            }
            double rescoredPref = rescorer == null ? preference : rescorer.rescore(itemID, preference);
            if (Double.isNaN(rescoredPref) || full && !(rescoredPref > lowestTopValue)) continue;
            topItems.add(new GenericRecommendedItem(itemID, (float)rescoredPref));
            if (full) {
                topItems.poll();
            } else if (topItems.size() > howMany) {
                full = true;
                topItems.poll();
            }
            lowestTopValue = ((RecommendedItem)topItems.peek()).getValue();
        }
        int size = topItems.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>(size);
        result.addAll(topItems);
        Collections.sort(result, ByValueRecommendedItemComparator.getInstance());
        return result;
    }

    public static long[] getTopUsers(int howMany, LongPrimitiveIterator allUserIDs, IDRescorer rescorer, Estimator<Long> estimator) throws TasteException {
        PriorityQueue topUsers = new PriorityQueue(howMany + 1, Collections.reverseOrder());
        boolean full = false;
        double lowestTopValue = Double.NEGATIVE_INFINITY;
        while (allUserIDs.hasNext()) {
            double similarity;
            long userID = (Long)allUserIDs.next();
            if (rescorer != null && rescorer.isFiltered(userID)) continue;
            try {
                similarity = estimator.estimate(userID);
            }
            catch (NoSuchUserException nsue) {
                continue;
            }
            double rescoredSimilarity = rescorer == null ? similarity : rescorer.rescore(userID, similarity);
            if (Double.isNaN(rescoredSimilarity) || full && !(rescoredSimilarity > lowestTopValue)) continue;
            topUsers.add(new SimilarUser(userID, similarity));
            if (full) {
                topUsers.poll();
            } else if (topUsers.size() > howMany) {
                full = true;
                topUsers.poll();
            }
            lowestTopValue = ((SimilarUser)topUsers.peek()).getSimilarity();
        }
        int size = topUsers.size();
        if (size == 0) {
            return NO_IDS;
        }
        ArrayList sorted = new ArrayList(size);
        sorted.addAll(topUsers);
        Collections.sort(sorted);
        long[] result = new long[size];
        int i = 0;
        for (SimilarUser similarUser : sorted) {
            result[i++] = similarUser.getUserID();
        }
        return result;
    }

    public static List<GenericItemSimilarity.ItemItemSimilarity> getTopItemItemSimilarities(int howMany, Iterator<GenericItemSimilarity.ItemItemSimilarity> allSimilarities) {
        PriorityQueue topSimilarities = new PriorityQueue(howMany + 1, Collections.reverseOrder());
        boolean full = false;
        double lowestTopValue = Double.NEGATIVE_INFINITY;
        while (allSimilarities.hasNext()) {
            GenericItemSimilarity.ItemItemSimilarity similarity = allSimilarities.next();
            double value = similarity.getValue();
            if (Double.isNaN(value) || full && !(value > lowestTopValue)) continue;
            topSimilarities.add(similarity);
            if (full) {
                topSimilarities.poll();
            } else if (topSimilarities.size() > howMany) {
                full = true;
                topSimilarities.poll();
            }
            lowestTopValue = ((GenericItemSimilarity.ItemItemSimilarity)topSimilarities.peek()).getValue();
        }
        int size = topSimilarities.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<GenericItemSimilarity.ItemItemSimilarity> result = new ArrayList<GenericItemSimilarity.ItemItemSimilarity>(size);
        result.addAll(topSimilarities);
        Collections.sort(result);
        return result;
    }

    public static List<GenericUserSimilarity.UserUserSimilarity> getTopUserUserSimilarities(int howMany, Iterator<GenericUserSimilarity.UserUserSimilarity> allSimilarities) {
        PriorityQueue topSimilarities = new PriorityQueue(howMany + 1, Collections.reverseOrder());
        boolean full = false;
        double lowestTopValue = Double.NEGATIVE_INFINITY;
        while (allSimilarities.hasNext()) {
            GenericUserSimilarity.UserUserSimilarity similarity = allSimilarities.next();
            double value = similarity.getValue();
            if (Double.isNaN(value) || full && !(value > lowestTopValue)) continue;
            topSimilarities.add(similarity);
            if (full) {
                topSimilarities.poll();
            } else if (topSimilarities.size() > howMany) {
                full = true;
                topSimilarities.poll();
            }
            lowestTopValue = ((GenericUserSimilarity.UserUserSimilarity)topSimilarities.peek()).getValue();
        }
        int size = topSimilarities.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<GenericUserSimilarity.UserUserSimilarity> result = new ArrayList<GenericUserSimilarity.UserUserSimilarity>(size);
        result.addAll(topSimilarities);
        Collections.sort(result);
        return result;
    }

    public static interface Estimator<T> {
        public double estimate(T var1) throws TasteException;
    }
}

