/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.AbstractCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.FixedSizeSamplingIterator;

public class SamplingCandidateItemsStrategy
extends AbstractCandidateItemsStrategy {
    private final int defaultMaxPrefsPerItemConsidered;
    private final int userItemCountMultiplier;

    public SamplingCandidateItemsStrategy() {
        this(100, 20);
    }

    public SamplingCandidateItemsStrategy(int defaultMaxPrefsPerItemConsidered, int userItemCountMultiplier) {
        this.defaultMaxPrefsPerItemConsidered = defaultMaxPrefsPerItemConsidered;
        this.userItemCountMultiplier = userItemCountMultiplier;
    }

    @Override
    protected FastIDSet doGetCandidateItems(long[] preferredItemIDs, DataModel dataModel) throws TasteException {
        int maxPrefsPerItemConsidered = (int)Math.max((double)this.defaultMaxPrefsPerItemConsidered, (double)this.userItemCountMultiplier * Math.log(Math.max(dataModel.getNumUsers(), dataModel.getNumItems())));
        FastIDSet possibleItemsIDs = new FastIDSet();
        for (long itemID : preferredItemIDs) {
            PreferenceArray prefs = dataModel.getPreferencesForItem(itemID);
            int prefsConsidered = Math.min(prefs.length(), maxPrefsPerItemConsidered);
            FixedSizeSamplingIterator sampledPrefs = new FixedSizeSamplingIterator(prefsConsidered, prefs.iterator());
            while (sampledPrefs.hasNext()) {
                possibleItemsIDs.addAll(dataModel.getItemIDsFromUser(((Preference)sampledPrefs.next()).getUserID()));
            }
        }
        possibleItemsIDs.removeAll(preferredItemIDs);
        return possibleItemsIDs;
    }
}

