/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.ClusterSimilarity;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class NearestNeighborClusterSimilarity
implements ClusterSimilarity {
    private final UserSimilarity similarity;
    private final double samplingRate;

    public NearestNeighborClusterSimilarity(UserSimilarity similarity) {
        this(similarity, 1.0);
    }

    public NearestNeighborClusterSimilarity(UserSimilarity similarity, double samplingRate) {
        Preconditions.checkArgument((similarity != null ? 1 : 0) != 0, (Object)"similarity is null");
        Preconditions.checkArgument((samplingRate > 0.0 && samplingRate <= 1.0 ? 1 : 0) != 0, (String)"samplingRate is invalid: %f", (Object[])new Object[]{samplingRate});
        this.similarity = similarity;
        this.samplingRate = samplingRate;
    }

    @Override
    public double getSimilarity(FastIDSet cluster1, FastIDSet cluster2) throws TasteException {
        if (cluster1.isEmpty() || cluster2.isEmpty()) {
            return Double.NaN;
        }
        LongPrimitiveIterator someUsers = SamplingLongPrimitiveIterator.maybeWrapIterator(cluster1.iterator(), this.samplingRate);
        double greatestSimilarity = Double.NEGATIVE_INFINITY;
        while (someUsers.hasNext()) {
            long userID1 = (Long)someUsers.next();
            LongPrimitiveIterator it2 = cluster2.iterator();
            while (it2.hasNext()) {
                double theSimilarity = this.similarity.userSimilarity(userID1, it2.nextLong());
                if (!(theSimilarity > greatestSimilarity)) continue;
                greatestSimilarity = theSimilarity;
            }
        }
        if (greatestSimilarity == Double.NEGATIVE_INFINITY) {
            return this.similarity.userSimilarity((Long)cluster1.iterator().next(), (Long)cluster2.iterator().next());
        }
        return greatestSimilarity;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.similarity);
    }

    public String toString() {
        return "NearestNeighborClusterSimilarity[similarity:" + this.similarity + ']';
    }
}

