/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.EstimatedPreferenceCapper;
import org.apache.mahout.cf.taste.impl.recommender.PreferredItemsNeighborhoodCandidateItemsStrategy;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.ItemBasedRecommender;
import org.apache.mahout.cf.taste.recommender.MostSimilarItemsCandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.LongPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericItemBasedRecommender
extends AbstractRecommender
implements ItemBasedRecommender {
    private static final Logger log = LoggerFactory.getLogger(GenericItemBasedRecommender.class);
    private final ItemSimilarity similarity;
    private final MostSimilarItemsCandidateItemsStrategy mostSimilarItemsCandidateItemsStrategy;
    private final RefreshHelper refreshHelper;
    private EstimatedPreferenceCapper capper;
    private static final boolean EXCLUDE_ITEM_IF_NOT_SIMILAR_TO_ALL_BY_DEFAULT = true;

    public GenericItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity, CandidateItemsStrategy candidateItemsStrategy, MostSimilarItemsCandidateItemsStrategy mostSimilarItemsCandidateItemsStrategy) {
        super(dataModel, candidateItemsStrategy);
        Preconditions.checkArgument((similarity != null ? 1 : 0) != 0, (Object)"similarity is null");
        this.similarity = similarity;
        Preconditions.checkArgument((mostSimilarItemsCandidateItemsStrategy != null ? 1 : 0) != 0, (Object)"mostSimilarItemsCandidateItemsStrategy is null");
        this.mostSimilarItemsCandidateItemsStrategy = mostSimilarItemsCandidateItemsStrategy;
        this.refreshHelper = new RefreshHelper(new Callable<Void>(){

            @Override
            public Void call() {
                GenericItemBasedRecommender.this.capper = GenericItemBasedRecommender.this.buildCapper();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.refreshHelper.addDependency(similarity);
        this.capper = this.buildCapper();
    }

    public GenericItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity) {
        this(dataModel, similarity, AbstractRecommender.getDefaultCandidateItemsStrategy(), GenericItemBasedRecommender.getDefaultMostSimilarItemsCandidateItemsStrategy());
    }

    protected static MostSimilarItemsCandidateItemsStrategy getDefaultMostSimilarItemsCandidateItemsStrategy() {
        return new PreferredItemsNeighborhoodCandidateItemsStrategy();
    }

    public ItemSimilarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument((howMany >= 1 ? 1 : 0) != 0, (Object)"howMany must be at least 1");
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        PreferenceArray preferencesFromUser = this.getDataModel().getPreferencesFromUser(userID);
        if (preferencesFromUser.length() == 0) {
            return Collections.emptyList();
        }
        FastIDSet possibleItemIDs = this.getAllOtherItems(userID, preferencesFromUser);
        Estimator estimator = new Estimator(userID, preferencesFromUser);
        List<RecommendedItem> topItems = TopItems.getTopItems(howMany, possibleItemIDs.iterator(), rescorer, estimator);
        log.debug("Recommendations are: {}", topItems);
        return topItems;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        PreferenceArray preferencesFromUser = this.getDataModel().getPreferencesFromUser(userID);
        Float actualPref = GenericItemBasedRecommender.getPreferenceForItem(preferencesFromUser, itemID);
        if (actualPref != null) {
            return actualPref.floatValue();
        }
        return this.doEstimatePreference(userID, preferencesFromUser, itemID);
    }

    private static Float getPreferenceForItem(PreferenceArray preferencesFromUser, long itemID) {
        int size = preferencesFromUser.length();
        for (int i = 0; i < size; ++i) {
            if (preferencesFromUser.getItemID(i) != itemID) continue;
            return Float.valueOf(preferencesFromUser.getValue(i));
        }
        return null;
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany) throws TasteException {
        return this.mostSimilarItems(itemID, howMany, null);
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        MostSimilarEstimator estimator = new MostSimilarEstimator(itemID, this.similarity, rescorer);
        return this.doMostSimilarItems(new long[]{itemID}, howMany, estimator);
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany) throws TasteException {
        MultiMostSimilarEstimator estimator = new MultiMostSimilarEstimator(itemIDs, this.similarity, null, true);
        return this.doMostSimilarItems(itemIDs, howMany, estimator);
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        MultiMostSimilarEstimator estimator = new MultiMostSimilarEstimator(itemIDs, this.similarity, rescorer, true);
        return this.doMostSimilarItems(itemIDs, howMany, estimator);
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, boolean excludeItemIfNotSimilarToAll) throws TasteException {
        MultiMostSimilarEstimator estimator = new MultiMostSimilarEstimator(itemIDs, this.similarity, null, excludeItemIfNotSimilarToAll);
        return this.doMostSimilarItems(itemIDs, howMany, estimator);
    }

    @Override
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer, boolean excludeItemIfNotSimilarToAll) throws TasteException {
        MultiMostSimilarEstimator estimator = new MultiMostSimilarEstimator(itemIDs, this.similarity, rescorer, excludeItemIfNotSimilarToAll);
        return this.doMostSimilarItems(itemIDs, howMany, estimator);
    }

    @Override
    public List<RecommendedItem> recommendedBecause(long userID, long itemID, int howMany) throws TasteException {
        Preconditions.checkArgument((howMany >= 1 ? 1 : 0) != 0, (Object)"howMany must be at least 1");
        DataModel model = this.getDataModel();
        RecommendedBecauseEstimator estimator = new RecommendedBecauseEstimator(userID, itemID);
        PreferenceArray prefs = model.getPreferencesFromUser(userID);
        int size = prefs.length();
        FastIDSet allUserItems = new FastIDSet(size);
        for (int i = 0; i < size; ++i) {
            allUserItems.add(prefs.getItemID(i));
        }
        allUserItems.remove(itemID);
        return TopItems.getTopItems(howMany, allUserItems.iterator(), null, estimator);
    }

    private List<RecommendedItem> doMostSimilarItems(long[] itemIDs, int howMany, TopItems.Estimator<Long> estimator) throws TasteException {
        FastIDSet possibleItemIDs = this.mostSimilarItemsCandidateItemsStrategy.getCandidateItems(itemIDs, this.getDataModel());
        return TopItems.getTopItems(howMany, possibleItemIDs.iterator(), null, estimator);
    }

    protected float doEstimatePreference(long userID, PreferenceArray preferencesFromUser, long itemID) throws TasteException {
        double preference = 0.0;
        double totalSimilarity = 0.0;
        int count = 0;
        double[] similarities = this.similarity.itemSimilarities(itemID, preferencesFromUser.getIDs());
        for (int i = 0; i < similarities.length; ++i) {
            double theSimilarity = similarities[i];
            if (Double.isNaN(theSimilarity)) continue;
            preference += theSimilarity * (double)preferencesFromUser.getValue(i);
            totalSimilarity += theSimilarity;
            ++count;
        }
        if (count <= 1) {
            return Float.NaN;
        }
        float estimate = (float)(preference / totalSimilarity);
        if (this.capper != null) {
            estimate = this.capper.capEstimate(estimate);
        }
        return estimate;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "GenericItemBasedRecommender[similarity:" + this.similarity + ']';
    }

    private EstimatedPreferenceCapper buildCapper() {
        DataModel dataModel = this.getDataModel();
        if (Float.isNaN(dataModel.getMinPreference()) && Float.isNaN(dataModel.getMaxPreference())) {
            return null;
        }
        return new EstimatedPreferenceCapper(dataModel);
    }

    private final class RecommendedBecauseEstimator
    implements TopItems.Estimator<Long> {
        private final long userID;
        private final long recommendedItemID;

        private RecommendedBecauseEstimator(long userID, long recommendedItemID) {
            this.userID = userID;
            this.recommendedItemID = recommendedItemID;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            Float pref = GenericItemBasedRecommender.this.getDataModel().getPreferenceValue(this.userID, itemID);
            if (pref == null) {
                return Double.NaN;
            }
            double similarityValue = GenericItemBasedRecommender.this.similarity.itemSimilarity(this.recommendedItemID, itemID);
            return (1.0 + similarityValue) * (double)pref.floatValue();
        }
    }

    private static final class MultiMostSimilarEstimator
    implements TopItems.Estimator<Long> {
        private final long[] toItemIDs;
        private final ItemSimilarity similarity;
        private final Rescorer<LongPair> rescorer;
        private final boolean excludeItemIfNotSimilarToAll;

        private MultiMostSimilarEstimator(long[] toItemIDs, ItemSimilarity similarity, Rescorer<LongPair> rescorer, boolean excludeItemIfNotSimilarToAll) {
            this.toItemIDs = toItemIDs;
            this.similarity = similarity;
            this.rescorer = rescorer;
            this.excludeItemIfNotSimilarToAll = excludeItemIfNotSimilarToAll;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            FullRunningAverage average = new FullRunningAverage();
            double[] similarities = this.similarity.itemSimilarities(itemID, this.toItemIDs);
            for (int i = 0; i < this.toItemIDs.length; ++i) {
                long toItemID = this.toItemIDs[i];
                LongPair pair = new LongPair(toItemID, itemID);
                if (this.rescorer != null && this.rescorer.isFiltered(pair)) continue;
                double estimate = similarities[i];
                if (this.rescorer != null) {
                    estimate = this.rescorer.rescore(pair, estimate);
                }
                if (!this.excludeItemIfNotSimilarToAll && Double.isNaN(estimate)) continue;
                average.addDatum(estimate);
            }
            double averageEstimate = average.getAverage();
            return averageEstimate == 0.0 ? Double.NaN : averageEstimate;
        }
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private final long userID;
        private final PreferenceArray preferencesFromUser;

        private Estimator(long userID, PreferenceArray preferencesFromUser) {
            this.userID = userID;
            this.preferencesFromUser = preferencesFromUser;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            return GenericItemBasedRecommender.this.doEstimatePreference(this.userID, this.preferencesFromUser, itemID);
        }
    }

    public static class MostSimilarEstimator
    implements TopItems.Estimator<Long> {
        private final long toItemID;
        private final ItemSimilarity similarity;
        private final Rescorer<LongPair> rescorer;

        public MostSimilarEstimator(long toItemID, ItemSimilarity similarity, Rescorer<LongPair> rescorer) {
            this.toItemID = toItemID;
            this.similarity = similarity;
            this.rescorer = rescorer;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            LongPair pair = new LongPair(this.toItemID, itemID);
            if (this.rescorer != null && this.rescorer.isFiltered(pair)) {
                return Double.NaN;
            }
            double originalEstimate = this.similarity.itemSimilarity(this.toItemID, itemID);
            return this.rescorer == null ? originalEstimate : this.rescorer.rescore(pair, originalEstimate);
        }
    }
}

