/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class GenericBooleanPrefUserBasedRecommender
extends GenericUserBasedRecommender {
    public GenericBooleanPrefUserBasedRecommender(DataModel dataModel, UserNeighborhood neighborhood, UserSimilarity similarity) {
        super(dataModel, neighborhood, similarity);
    }

    @Override
    protected float doEstimatePreference(long theUserID, long[] theNeighborhood, long itemID) throws TasteException {
        if (theNeighborhood.length == 0) {
            return Float.NaN;
        }
        DataModel dataModel = this.getDataModel();
        UserSimilarity similarity = this.getSimilarity();
        float totalSimilarity = 0.0f;
        boolean foundAPref = false;
        for (long userID : theNeighborhood) {
            if (userID == theUserID || dataModel.getPreferenceValue(userID, itemID) == null) continue;
            foundAPref = true;
            totalSimilarity = (float)((double)totalSimilarity + similarity.userSimilarity(theUserID, userID));
        }
        return foundAPref ? totalSimilarity : Float.NaN;
    }

    @Override
    protected FastIDSet getAllOtherItems(long[] theNeighborhood, long theUserID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        FastIDSet possibleItemIDs = new FastIDSet();
        for (long userID : theNeighborhood) {
            possibleItemIDs.addAll(dataModel.getItemIDsFromUser(userID));
        }
        possibleItemIDs.removeAll(dataModel.getItemIDsFromUser(theUserID));
        return possibleItemIDs;
    }

    @Override
    public String toString() {
        return "GenericBooleanPrefUserBasedRecommender";
    }
}

