/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.jdbc.AbstractJDBCComponent;
import org.apache.mahout.cf.taste.impl.model.jdbc.AbstractJDBCDataModel;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLJDBCDataModel
extends AbstractJDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLJDBCDataModel.class);
    private static final String POSTGRESQL_DUPLICATE_KEY_STATE = "23505";
    private final String updatePreferenceSQL;

    public PostgreSQLJDBCDataModel() throws TasteException {
        this("jdbc/taste");
    }

    public PostgreSQLJDBCDataModel(String dataSourceName) throws TasteException {
        this(AbstractJDBCComponent.lookupDataSource(dataSourceName), "taste_preferences", "user_id", "item_id", "preference", "timestamp");
    }

    public PostgreSQLJDBCDataModel(DataSource dataSource) {
        this(dataSource, "taste_preferences", "user_id", "item_id", "preference", "timestamp");
    }

    public PostgreSQLJDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String preferenceColumn, String timestampColumn) {
        super(dataSource, preferenceTable, userIDColumn, itemIDColumn, preferenceColumn, "SELECT " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT " + timestampColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + ", " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + userIDColumn + "=? ORDER BY " + itemIDColumn, "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + ", " + preferenceColumn + " FROM " + preferenceTable + " ORDER BY " + userIDColumn + ", " + itemIDColumn, "SELECT COUNT(DISTINCT " + itemIDColumn + ") FROM " + preferenceTable, "SELECT COUNT(DISTINCT " + userIDColumn + ") FROM " + preferenceTable, "INSERT INTO " + preferenceTable + '(' + userIDColumn + ',' + itemIDColumn + ',' + preferenceColumn + ") VALUES (?,?,?)", "DELETE FROM " + preferenceTable + " WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?", "SELECT DISTINCT " + userIDColumn + " FROM " + preferenceTable + " ORDER BY " + userIDColumn, "SELECT DISTINCT " + itemIDColumn + " FROM " + preferenceTable + " ORDER BY " + itemIDColumn, "SELECT DISTINCT " + userIDColumn + ", " + itemIDColumn + ", " + preferenceColumn + " FROM " + preferenceTable + " WHERE " + itemIDColumn + "=? ORDER BY " + userIDColumn, "SELECT COUNT(1) FROM " + preferenceTable + " WHERE " + itemIDColumn + "=?", "SELECT COUNT(1) FROM " + preferenceTable + " tp1 JOIN " + preferenceTable + " tp2 " + "USING (" + userIDColumn + ") WHERE tp1." + itemIDColumn + "=? and tp2." + itemIDColumn + "=?", "SELECT MAX(" + preferenceColumn + ") FROM " + preferenceTable, "SELECT MIN(" + preferenceColumn + ") FROM " + preferenceTable);
        this.updatePreferenceSQL = "UPDATE " + preferenceTable + " SET " + preferenceColumn + "=? WHERE " + userIDColumn + "=? AND " + itemIDColumn + "=?";
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument((!Float.isNaN(value) ? 1 : 0) != 0, (Object)"NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        String setPreferenceSQL = this.getSetPreferenceSQL();
        Connection conn = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        try {
            block6: {
                conn = this.getDataSource().getConnection();
                stmt1 = conn.prepareStatement(setPreferenceSQL);
                this.setLongParameter(stmt1, 1, userID);
                this.setLongParameter(stmt1, 2, itemID);
                stmt1.setDouble(3, value);
                log.debug("Executing SQL update: {}", (Object)setPreferenceSQL);
                try {
                    stmt1.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (POSTGRESQL_DUPLICATE_KEY_STATE.equals(sqle.getSQLState())) break block6;
                    throw sqle;
                }
            }
            stmt2 = conn.prepareStatement(this.updatePreferenceSQL);
            stmt2.setDouble(1, value);
            this.setLongParameter(stmt2, 2, userID);
            this.setLongParameter(stmt2, 3, itemID);
            log.debug("Executing SQL update: {}", (Object)this.updatePreferenceSQL);
            stmt2.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while setting preference", (Throwable)sqle);
                throw new TasteException(sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt1, null);
                IOUtils.quietClose(null, stmt2, null);
                IOUtils.quietClose(null, null, conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, stmt1, null);
        IOUtils.quietClose(null, stmt2, null);
        IOUtils.quietClose(null, null, conn);
    }
}

