/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.model.AbstractIDMigrator;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIDMigrator
extends AbstractIDMigrator {
    public static final long DEFAULT_MIN_RELOAD_INTERVAL_MS = 60000L;
    private final File dataFile;
    private FastByIDMap<String> longToString = new FastByIDMap(100);
    private final ReentrantLock reloadLock;
    private long lastModified;
    private long minReloadIntervalMS;
    private static final Logger log = LoggerFactory.getLogger(FileIDMigrator.class);

    public FileIDMigrator(File dataFile) throws FileNotFoundException {
        this(dataFile, 60000L);
    }

    public FileIDMigrator(File dataFile, long minReloadIntervalMS) throws FileNotFoundException {
        Preconditions.checkArgument((dataFile != null ? 1 : 0) != 0, (Object)"dataFile is null");
        if (!dataFile.exists() || dataFile.isDirectory()) {
            throw new FileNotFoundException(dataFile.toString());
        }
        log.info("Creating FileReadonlyIDMigrator for file {}", (Object)dataFile);
        this.dataFile = dataFile;
        this.reloadLock = new ReentrantLock();
        this.lastModified = dataFile.lastModified();
        this.minReloadIntervalMS = minReloadIntervalMS;
        this.reload();
    }

    @Override
    public String toStringID(long longID) {
        return this.longToString.get(longID);
    }

    private void reload() {
        if (this.reloadLock.tryLock()) {
            try {
                this.longToString = this.buildMapping();
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
            finally {
                this.reloadLock.unlock();
            }
        }
    }

    private FastByIDMap<String> buildMapping() throws IOException {
        FastByIDMap<String> mapping = new FastByIDMap<String>();
        for (String line : new FileLineIterable(this.dataFile)) {
            mapping.put(this.toLongID(line), line);
        }
        this.lastModified = this.dataFile.lastModified();
        return mapping;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (this.dataFile.lastModified() > this.lastModified + this.minReloadIntervalMS) {
            log.debug("File has changed; reloading...");
            this.reload();
        }
    }

    public String toString() {
        return "FileIDMigrator[dataFile:" + this.dataFile + ']';
    }
}

