/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.PlusAnonymousUserLongPrimitiveIterator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;

public final class PlusAnonymousUserDataModel
implements DataModel {
    public static final long TEMP_USER_ID = Long.MIN_VALUE;
    private final DataModel delegate;
    private PreferenceArray tempPrefs;
    private final FastIDSet prefItemIDs;

    public PlusAnonymousUserDataModel(DataModel delegate) {
        this.delegate = delegate;
        this.prefItemIDs = new FastIDSet();
    }

    public void setTempPrefs(PreferenceArray prefs) {
        Preconditions.checkArgument((prefs != null && prefs.length() > 0 ? 1 : 0) != 0, (Object)"prefs is null or empty");
        this.tempPrefs = prefs;
        this.prefItemIDs.clear();
        for (int i = 0; i < prefs.length(); ++i) {
            this.prefItemIDs.add(prefs.getItemID(i));
        }
    }

    public void clearTempPrefs() {
        this.tempPrefs = null;
        this.prefItemIDs.clear();
    }

    @Override
    public LongPrimitiveIterator getUserIDs() throws TasteException {
        if (this.tempPrefs == null) {
            return this.delegate.getUserIDs();
        }
        return new PlusAnonymousUserLongPrimitiveIterator(this.delegate.getUserIDs(), Long.MIN_VALUE);
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            return this.tempPrefs;
        }
        return this.delegate.getPreferencesFromUser(userID);
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            return this.prefItemIDs;
        }
        return this.delegate.getItemIDsFromUser(userID);
    }

    @Override
    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegate.getItemIDs();
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        if (this.tempPrefs == null) {
            return this.delegate.getPreferencesForItem(itemID);
        }
        PreferenceArray delegatePrefs = null;
        try {
            delegatePrefs = this.delegate.getPreferencesForItem(itemID);
        }
        catch (NoSuchItemException nsie) {
            // empty catch block
        }
        for (int i = 0; i < this.tempPrefs.length(); ++i) {
            if (this.tempPrefs.getItemID(i) != itemID) continue;
            int length = delegatePrefs == null ? 0 : delegatePrefs.length();
            GenericItemPreferenceArray newPreferenceArray = new GenericItemPreferenceArray(length + 1);
            for (int j = 0; j < length; ++j) {
                newPreferenceArray.setUserID(j, delegatePrefs.getUserID(j));
                newPreferenceArray.setItemID(j, delegatePrefs.getItemID(j));
                newPreferenceArray.setValue(j, delegatePrefs.getValue(j));
            }
            newPreferenceArray.setUserID(length, this.tempPrefs.getUserID(i));
            newPreferenceArray.setItemID(length, this.tempPrefs.getItemID(i));
            newPreferenceArray.setValue(length, this.tempPrefs.getValue(i));
            newPreferenceArray.sortByUser();
            return newPreferenceArray;
        }
        if (delegatePrefs == null) {
            throw new NoSuchItemException(itemID);
        }
        return delegatePrefs;
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            for (int i = 0; i < this.tempPrefs.length(); ++i) {
                if (this.tempPrefs.getItemID(i) != itemID) continue;
                return Float.valueOf(this.tempPrefs.getValue(i));
            }
            return null;
        }
        return this.delegate.getPreferenceValue(userID, itemID);
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            return null;
        }
        return this.delegate.getPreferenceTime(userID, itemID);
    }

    @Override
    public int getNumItems() throws TasteException {
        return this.delegate.getNumItems();
    }

    @Override
    public int getNumUsers() throws TasteException {
        return this.delegate.getNumUsers() + (this.tempPrefs == null ? 0 : 1);
    }

    @Override
    public int getNumUsersWithPreferenceFor(long ... itemIDs) throws TasteException {
        if (this.tempPrefs == null) {
            return this.delegate.getNumUsersWithPreferenceFor(itemIDs);
        }
        boolean hasAll = true;
        for (long itemID : itemIDs) {
            boolean found = false;
            for (int i = 0; i < this.tempPrefs.length(); ++i) {
                if (this.tempPrefs.getItemID(i) != itemID) continue;
                found = true;
                break;
            }
            if (found) continue;
            hasAll = false;
            break;
        }
        return this.delegate.getNumUsersWithPreferenceFor(itemIDs) + (hasAll ? 1 : 0);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            throw new UnsupportedOperationException();
        }
        this.delegate.setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        if (userID == Long.MIN_VALUE) {
            if (this.tempPrefs == null) {
                throw new NoSuchUserException(Long.MIN_VALUE);
            }
            throw new UnsupportedOperationException();
        }
        this.delegate.removePreference(userID, itemID);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.delegate.refresh(alreadyRefreshed);
    }

    @Override
    public boolean hasPreferenceValues() {
        return this.delegate.hasPreferenceValues();
    }

    @Override
    public float getMaxPreference() {
        return this.delegate.getMaxPreference();
    }

    @Override
    public float getMinPreference() {
        return this.delegate.getMinPreference();
    }
}

