/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveArrayIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.AbstractDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericDataModel
extends AbstractDataModel {
    private static final Logger log = LoggerFactory.getLogger(GenericDataModel.class);
    private final long[] userIDs;
    private final FastByIDMap<PreferenceArray> preferenceFromUsers;
    private final long[] itemIDs;
    private final FastByIDMap<PreferenceArray> preferenceForItems;
    private final FastByIDMap<FastByIDMap<Long>> timestamps;

    public GenericDataModel(FastByIDMap<PreferenceArray> userData) {
        this(userData, null);
    }

    public GenericDataModel(FastByIDMap<PreferenceArray> userData, FastByIDMap<FastByIDMap<Long>> timestamps) {
        Preconditions.checkArgument((userData != null ? 1 : 0) != 0, (Object)"userData is null");
        this.preferenceFromUsers = userData;
        FastByIDMap<Collection<Preference>> prefsForItems = new FastByIDMap<Collection<Preference>>();
        FastIDSet itemIDSet = new FastIDSet();
        int currentCount = 0;
        float maxPrefValue = Float.NEGATIVE_INFINITY;
        float minPrefValue = Float.POSITIVE_INFINITY;
        for (Map.Entry<Long, PreferenceArray> entry : this.preferenceFromUsers.entrySet()) {
            PreferenceArray prefs = entry.getValue();
            prefs.sortByItem();
            for (Preference preference : prefs) {
                long itemID = preference.getItemID();
                itemIDSet.add(itemID);
                Collection<Preference> prefsForItem = prefsForItems.get(itemID);
                if (prefsForItem == null) {
                    prefsForItem = new ArrayList<Preference>(2);
                    prefsForItems.put(itemID, prefsForItem);
                }
                prefsForItem.add(preference);
                float value = preference.getValue();
                if (value > maxPrefValue) {
                    maxPrefValue = value;
                }
                if (!(value < minPrefValue)) continue;
                minPrefValue = value;
            }
            if (++currentCount % 10000 != 0) continue;
            log.info("Processed {} users", (Object)currentCount);
        }
        log.info("Processed {} users", (Object)currentCount);
        this.setMinPreference(minPrefValue);
        this.setMaxPreference(maxPrefValue);
        this.itemIDs = itemIDSet.toArray();
        itemIDSet = null;
        Arrays.sort(this.itemIDs);
        this.preferenceForItems = GenericDataModel.toDataMap(prefsForItems, false);
        for (Map.Entry<Long, PreferenceArray> entry : this.preferenceForItems.entrySet()) {
            entry.getValue().sortByUser();
        }
        this.userIDs = new long[userData.size()];
        int i = 0;
        LongPrimitiveIterator it = userData.keySetIterator();
        while (it.hasNext()) {
            this.userIDs[i++] = (Long)it.next();
        }
        Arrays.sort(this.userIDs);
        this.timestamps = timestamps;
    }

    @Deprecated
    public GenericDataModel(DataModel dataModel) throws TasteException {
        this(GenericDataModel.toDataMap(dataModel));
    }

    public static FastByIDMap<PreferenceArray> toDataMap(FastByIDMap<Collection<Preference>> data, boolean byUser) {
        for (Map.Entry<Long, Collection<Preference>> entry : data.entrySet()) {
            List prefList = (List)entry.getValue();
            entry.setValue((Collection<Preference>)((Object)(byUser ? new GenericUserPreferenceArray(prefList) : new GenericItemPreferenceArray(prefList))));
        }
        return data;
    }

    public static FastByIDMap<PreferenceArray> toDataMap(DataModel dataModel) throws TasteException {
        FastByIDMap<PreferenceArray> data = new FastByIDMap<PreferenceArray>(dataModel.getNumUsers());
        LongPrimitiveIterator it = dataModel.getUserIDs();
        while (it.hasNext()) {
            long userID = it.nextLong();
            data.put(userID, dataModel.getPreferencesFromUser(userID));
        }
        return data;
    }

    public FastByIDMap<PreferenceArray> getRawUserData() {
        return this.preferenceFromUsers;
    }

    public FastByIDMap<PreferenceArray> getRawItemData() {
        return this.preferenceForItems;
    }

    @Override
    public LongPrimitiveArrayIterator getUserIDs() {
        return new LongPrimitiveArrayIterator(this.userIDs);
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws NoSuchUserException {
        PreferenceArray prefs = this.preferenceFromUsers.get(userID);
        if (prefs == null) {
            throw new NoSuchUserException(userID);
        }
        return prefs;
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        PreferenceArray prefs = this.getPreferencesFromUser(userID);
        int size = prefs.length();
        FastIDSet result = new FastIDSet(size);
        for (int i = 0; i < size; ++i) {
            result.add(prefs.getItemID(i));
        }
        return result;
    }

    @Override
    public LongPrimitiveArrayIterator getItemIDs() {
        return new LongPrimitiveArrayIterator(this.itemIDs);
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws NoSuchItemException {
        PreferenceArray prefs = this.preferenceForItems.get(itemID);
        if (prefs == null) {
            throw new NoSuchItemException(itemID);
        }
        return prefs;
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        PreferenceArray prefs = this.getPreferencesFromUser(userID);
        int size = prefs.length();
        for (int i = 0; i < size; ++i) {
            if (prefs.getItemID(i) != itemID) continue;
            return Float.valueOf(prefs.getValue(i));
        }
        return null;
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        if (this.timestamps == null) {
            return null;
        }
        FastByIDMap<Long> itemTimestamps = this.timestamps.get(userID);
        if (itemTimestamps == null) {
            throw new NoSuchUserException(userID);
        }
        return itemTimestamps.get(itemID);
    }

    @Override
    public int getNumItems() {
        return this.itemIDs.length;
    }

    @Override
    public int getNumUsers() {
        return this.userIDs.length;
    }

    @Override
    public int getNumUsersWithPreferenceFor(long ... itemIDs) {
        Preconditions.checkArgument((itemIDs != null ? 1 : 0) != 0, (Object)"itemIDs is null");
        Preconditions.checkArgument((itemIDs.length == 1 || itemIDs.length == 2 ? 1 : 0) != 0, (String)"Illegal number of IDs", (Object[])new Object[]{itemIDs.length});
        PreferenceArray prefs1 = this.preferenceForItems.get(itemIDs[0]);
        if (prefs1 == null) {
            return 0;
        }
        if (itemIDs.length == 1) {
            return prefs1.length();
        }
        PreferenceArray prefs2 = this.preferenceForItems.get(itemIDs[1]);
        if (prefs2 == null) {
            return 0;
        }
        FastIDSet users1 = new FastIDSet(prefs1.length());
        int size1 = prefs1.length();
        for (int i = 0; i < size1; ++i) {
            users1.add(prefs1.getUserID(i));
        }
        FastIDSet users2 = new FastIDSet(prefs2.length());
        int size2 = prefs2.length();
        for (int i = 0; i < size2; ++i) {
            users2.add(prefs2.getUserID(i));
        }
        users1.retainAll(users2);
        return users1.size();
    }

    @Override
    public void removePreference(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreference(long userID, long itemID, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    @Override
    public boolean hasPreferenceValues() {
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("GenericDataModel[users:");
        for (int i = 0; i < Math.min(3, this.userIDs.length); ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.userIDs[i]);
        }
        if (result.length() > 3) {
            result.append("...");
        }
        result.append(']');
        return result.toString();
    }
}

