/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.eval.AbstractDifferenceRecommenderEvaluator;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.Recommender;

public final class LoadEvaluator {
    private LoadEvaluator() {
    }

    public static void runLoad(Recommender recommender) throws TasteException {
        DataModel dataModel = recommender.getDataModel();
        int numUsers = dataModel.getNumUsers();
        double sampleRate = 1000.0 / (double)numUsers;
        LongPrimitiveIterator userSampler = SamplingLongPrimitiveIterator.maybeWrapIterator(dataModel.getUserIDs(), sampleRate);
        recommender.recommend((Long)userSampler.next(), 10);
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
        while (userSampler.hasNext()) {
            callables.add(new LoadCallable(recommender, (Long)userSampler.next()));
        }
        AbstractDifferenceRecommenderEvaluator.execute(callables, new AtomicInteger());
    }

    private static final class LoadCallable
    implements Callable<Void> {
        private final Recommender recommender;
        private final long userID;

        private LoadCallable(Recommender recommender, long userID) {
            this.recommender = recommender;
            this.userID = userID;
        }

        @Override
        public Void call() throws Exception {
            this.recommender.recommend(this.userID, 10);
            return null;
        }
    }
}

