/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.eval.DataModelBuilder;
import org.apache.mahout.cf.taste.eval.IRStatistics;
import org.apache.mahout.cf.taste.eval.RecommenderBuilder;
import org.apache.mahout.cf.taste.eval.RecommenderIRStatsEvaluator;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.eval.IRStatisticsImpl;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericRecommenderIRStatsEvaluator
implements RecommenderIRStatsEvaluator {
    private static final Logger log = LoggerFactory.getLogger(GenericRecommenderIRStatsEvaluator.class);
    private static final double LOG2 = Math.log(2.0);
    public static final double CHOOSE_THRESHOLD = Double.NaN;
    private final Random random = RandomUtils.getRandom();

    @Override
    public IRStatistics evaluate(RecommenderBuilder recommenderBuilder, DataModelBuilder dataModelBuilder, DataModel dataModel, IDRescorer rescorer, int at, double relevanceThreshold, double evaluationPercentage) throws TasteException {
        Preconditions.checkArgument((recommenderBuilder != null ? 1 : 0) != 0, (Object)"recommenderBuilder is null");
        Preconditions.checkArgument((dataModel != null ? 1 : 0) != 0, (Object)"dataModel is null");
        Preconditions.checkArgument((at >= 1 ? 1 : 0) != 0, (Object)"at must be at least 1");
        Preconditions.checkArgument((evaluationPercentage > 0.0 && evaluationPercentage <= 1.0 ? 1 : 0) != 0, (String)"Invalid evaluationPercentage: %s", (Object[])new Object[]{evaluationPercentage});
        int numItems = dataModel.getNumItems();
        FullRunningAverage precision = new FullRunningAverage();
        FullRunningAverage recall = new FullRunningAverage();
        FullRunningAverage fallOut = new FullRunningAverage();
        FullRunningAverage nDCG = new FullRunningAverage();
        LongPrimitiveIterator it = dataModel.getUserIDs();
        while (it.hasNext()) {
            long userID = it.nextLong();
            if (this.random.nextDouble() >= evaluationPercentage) continue;
            long start = System.currentTimeMillis();
            PreferenceArray prefs = dataModel.getPreferencesFromUser(userID);
            int size = prefs.length();
            if (size < 2 * at) continue;
            FastIDSet relevantItemIDs = new FastIDSet(at);
            double theRelevanceThreshold = Double.isNaN(relevanceThreshold) ? GenericRecommenderIRStatsEvaluator.computeThreshold(prefs) : relevanceThreshold;
            prefs.sortByValueReversed();
            for (int i = 0; i < size && relevantItemIDs.size() < at; ++i) {
                if (!((double)prefs.getValue(i) >= theRelevanceThreshold)) continue;
                relevantItemIDs.add(prefs.getItemID(i));
            }
            int numRelevantItems = relevantItemIDs.size();
            if (numRelevantItems <= 0) continue;
            FastByIDMap<PreferenceArray> trainingUsers = new FastByIDMap<PreferenceArray>(dataModel.getNumUsers());
            LongPrimitiveIterator it2 = dataModel.getUserIDs();
            while (it2.hasNext()) {
                GenericRecommenderIRStatsEvaluator.processOtherUser(userID, relevantItemIDs, trainingUsers, it2.nextLong(), dataModel);
            }
            DataModel trainingModel = dataModelBuilder == null ? new GenericDataModel(trainingUsers) : dataModelBuilder.buildDataModel(trainingUsers);
            Recommender recommender = recommenderBuilder.buildRecommender(trainingModel);
            try {
                trainingModel.getPreferencesFromUser(userID);
            }
            catch (NoSuchUserException nsee) {
                continue;
            }
            int intersectionSize = 0;
            List<RecommendedItem> recommendedItems = recommender.recommend(userID, at, rescorer);
            for (RecommendedItem recommendedItem : recommendedItems) {
                if (!relevantItemIDs.contains(recommendedItem.getItemID())) continue;
                ++intersectionSize;
            }
            int numRecommendedItems = recommendedItems.size();
            if (numRecommendedItems > 0) {
                precision.addDatum((double)intersectionSize / (double)numRecommendedItems);
            }
            recall.addDatum((double)intersectionSize / (double)numRelevantItems);
            if (numRelevantItems < size) {
                fallOut.addDatum((double)(numRecommendedItems - intersectionSize) / (double)(numItems - numRelevantItems));
            }
            double cumulativeGain = 0.0;
            double idealizedGain = 0.0;
            for (int i = 0; i < recommendedItems.size(); ++i) {
                double discount;
                RecommendedItem item = recommendedItems.get(i);
                double d = discount = i == 0 ? 1.0 : 1.0 / GenericRecommenderIRStatsEvaluator.log2(i + 1);
                if (relevantItemIDs.contains(item.getItemID())) {
                    cumulativeGain += discount;
                }
                if (i >= relevantItemIDs.size()) continue;
                idealizedGain += discount;
            }
            nDCG.addDatum(cumulativeGain / idealizedGain);
            long end = System.currentTimeMillis();
            log.info("Evaluated with user {} in {}ms", (Object)userID, (Object)(end - start));
            log.info("Precision/recall/fall-out/nDCG: {} / {} / {} / {}", new Object[]{precision.getAverage(), recall.getAverage(), fallOut.getAverage(), nDCG.getAverage()});
        }
        return new IRStatisticsImpl(precision.getAverage(), recall.getAverage(), fallOut.getAverage(), nDCG.getAverage());
    }

    private static void processOtherUser(long id, FastIDSet relevantItemIDs, FastByIDMap<PreferenceArray> trainingUsers, long userID2, DataModel dataModel) throws TasteException {
        PreferenceArray prefs2Array = dataModel.getPreferencesFromUser(userID2);
        if (id == userID2) {
            ArrayList<Preference> prefs2 = new ArrayList<Preference>(prefs2Array.length());
            for (Preference pref : prefs2Array) {
                prefs2.add(pref);
            }
            Iterator iterator = prefs2.iterator();
            while (iterator.hasNext()) {
                Preference pref;
                pref = (Preference)iterator.next();
                if (!relevantItemIDs.contains(pref.getItemID())) continue;
                iterator.remove();
            }
            if (!prefs2.isEmpty()) {
                trainingUsers.put(userID2, new GenericUserPreferenceArray(prefs2));
            }
        } else {
            trainingUsers.put(userID2, prefs2Array);
        }
    }

    private static double computeThreshold(PreferenceArray prefs) {
        if (prefs.length() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        FullRunningAverageAndStdDev stdDev = new FullRunningAverageAndStdDev();
        int size = prefs.length();
        for (int i = 0; i < size; ++i) {
            stdDev.addDatum(prefs.getValue(i));
        }
        return stdDev.getAverage() + stdDev.getStandardDeviation();
    }

    private static double log2(double value) {
        return Math.log(value) / LOG2;
    }
}

