/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import java.io.Serializable;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;

public class FullRunningAverage
implements RunningAverage,
Serializable {
    private int count = 0;
    private double average = Double.NaN;

    @Override
    public synchronized void addDatum(double datum) {
        this.average = ++this.count == 1 ? datum : this.average * (double)(this.count - 1) / (double)this.count + datum / (double)this.count;
    }

    @Override
    public synchronized void removeDatum(double datum) {
        if (this.count == 0) {
            throw new IllegalStateException();
        }
        this.average = --this.count == 0 ? Double.NaN : this.average * (double)(this.count + 1) / (double)this.count - datum / (double)this.count;
    }

    @Override
    public synchronized void changeDatum(double delta) {
        if (this.count == 0) {
            throw new IllegalStateException();
        }
        this.average += delta / (double)this.count;
    }

    @Override
    public synchronized int getCount() {
        return this.count;
    }

    @Override
    public synchronized double getAverage() {
        return this.average;
    }

    public synchronized String toString() {
        return String.valueOf(this.average);
    }
}

