/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.BitSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.common.RandomUtils;

public final class FastByIDMap<V>
implements Serializable,
Cloneable {
    public static final int NO_MAX_SIZE = Integer.MAX_VALUE;
    private static final double ALLOWED_LOAD_FACTOR = 1.5;
    private static final long REMOVED = Long.MAX_VALUE;
    private static final long NULL = Long.MIN_VALUE;
    private long[] keys;
    private V[] values;
    private int numEntries;
    private int numSlotsUsed;
    private final int maxSize;
    private BitSet recentlyAccessed;
    private final boolean countingAccesses;

    public FastByIDMap() {
        this(2, Integer.MAX_VALUE);
    }

    public FastByIDMap(int size) {
        this(size, Integer.MAX_VALUE);
    }

    public FastByIDMap(int size, int maxSize) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size must be at least 0");
        int max = 0x55555383;
        Preconditions.checkArgument((size < max ? 1 : 0) != 0, (Object)("size must be less than " + max));
        Preconditions.checkArgument((maxSize >= 1 ? 1 : 0) != 0, (Object)"maxSize must be at least 1");
        int hashSize = RandomUtils.nextTwinPrime((int)((int)(1.5 * (double)size)));
        this.keys = new long[hashSize];
        Arrays.fill(this.keys, Long.MIN_VALUE);
        this.values = new Object[hashSize];
        this.maxSize = maxSize;
        this.countingAccesses = maxSize != Integer.MAX_VALUE;
        this.recentlyAccessed = this.countingAccesses ? new BitSet(hashSize) : null;
    }

    private int find(long key) {
        int theHashCode = (int)key & Integer.MAX_VALUE;
        long[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        long currentKey = keys[index];
        while (currentKey != Long.MIN_VALUE && key != currentKey) {
            index = index < jump ? (index += hashSize - jump) : (index -= jump);
            currentKey = keys[index];
        }
        return index;
    }

    private int findForAdd(long key) {
        int theHashCode = (int)key & Integer.MAX_VALUE;
        long[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        long currentKey = keys[index];
        while (currentKey != Long.MIN_VALUE && currentKey != Long.MAX_VALUE && key != currentKey) {
            index = index < jump ? (index += hashSize - jump) : (index -= jump);
            currentKey = keys[index];
        }
        return index;
    }

    public V get(long key) {
        if (key == Long.MIN_VALUE) {
            return null;
        }
        int index = this.find(key);
        if (this.countingAccesses) {
            this.recentlyAccessed.set(index);
        }
        return this.values[index];
    }

    public int size() {
        return this.numEntries;
    }

    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    public boolean containsKey(long key) {
        return key != Long.MIN_VALUE && key != Long.MAX_VALUE && this.keys[this.find(key)] != Long.MIN_VALUE;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (V theValue : this.values) {
            if (theValue == null || !value.equals(theValue)) continue;
            return true;
        }
        return false;
    }

    public V put(long key, V value) {
        int index;
        long keyIndex;
        Preconditions.checkArgument((key != Long.MIN_VALUE && key != Long.MAX_VALUE ? 1 : 0) != 0);
        if (value == null) {
            throw new NullPointerException();
        }
        if ((double)this.numSlotsUsed * 1.5 >= (double)this.keys.length) {
            if ((double)this.numEntries * 1.5 >= (double)this.numSlotsUsed) {
                this.growAndRehash();
            } else {
                this.rehash();
            }
        }
        if ((keyIndex = this.keys[index = this.findForAdd(key)]) == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        if (this.countingAccesses && this.numEntries >= this.maxSize) {
            this.clearStaleEntry(index);
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.numEntries;
        if (keyIndex == Long.MIN_VALUE) {
            ++this.numSlotsUsed;
        }
        return null;
    }

    private void clearStaleEntry(int index) {
        while (true) {
            index = index == 0 ? this.keys.length - 1 : --index;
            long currentKey = this.keys[index];
            if (currentKey == Long.MIN_VALUE || currentKey == Long.MAX_VALUE) continue;
            if (!this.recentlyAccessed.get(index)) break;
            this.recentlyAccessed.clear(index);
        }
        this.keys[index] = Long.MAX_VALUE;
        --this.numEntries;
        this.values[index] = null;
    }

    public V remove(long key) {
        if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) {
            return null;
        }
        int index = this.find(key);
        if (this.keys[index] == Long.MIN_VALUE) {
            return null;
        }
        this.keys[index] = Long.MAX_VALUE;
        --this.numEntries;
        V oldValue = this.values[index];
        this.values[index] = null;
        return oldValue;
    }

    public void clear() {
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        Arrays.fill(this.keys, Long.MIN_VALUE);
        Arrays.fill(this.values, null);
        if (this.countingAccesses) {
            this.recentlyAccessed.clear();
        }
    }

    public LongPrimitiveIterator keySetIterator() {
        return new KeyIterator();
    }

    public Set<Map.Entry<Long, V>> entrySet() {
        return new EntrySet();
    }

    public void rehash() {
        this.rehash(RandomUtils.nextTwinPrime((int)((int)(1.5 * (double)this.numEntries))));
    }

    private void growAndRehash() {
        if ((double)this.keys.length * 1.5 >= 2.147482949E9) {
            throw new IllegalStateException("Can't grow any more");
        }
        this.rehash(RandomUtils.nextTwinPrime((int)((int)(1.5 * (double)this.keys.length))));
    }

    private void rehash(int newHashSize) {
        long[] oldKeys = this.keys;
        V[] oldValues = this.values;
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        if (this.countingAccesses) {
            this.recentlyAccessed = new BitSet(newHashSize);
        }
        this.keys = new long[newHashSize];
        Arrays.fill(this.keys, Long.MIN_VALUE);
        this.values = new Object[newHashSize];
        int length = oldKeys.length;
        for (int i = 0; i < length; ++i) {
            long key = oldKeys[i];
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            this.put(key, oldValues[i]);
        }
    }

    void iteratorRemove(int lastNext) {
        if (lastNext >= this.values.length) {
            throw new NoSuchElementException();
        }
        if (lastNext < 0) {
            throw new IllegalStateException();
        }
        this.values[lastNext] = null;
        this.keys[lastNext] = Long.MAX_VALUE;
        --this.numEntries;
    }

    public FastByIDMap<V> clone() {
        FastByIDMap clone;
        try {
            clone = (FastByIDMap)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError();
        }
        clone.keys = (long[])this.keys.clone();
        clone.values = (Object[])this.values.clone();
        clone.recentlyAccessed = this.countingAccesses ? new BitSet(this.keys.length) : null;
        return clone;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            result.append(key).append('=').append(this.values[i]).append(',');
        }
        result.setCharAt(result.length() - 1, '}');
        return result.toString();
    }

    public int hashCode() {
        int hash = 0;
        long[] keys = this.keys;
        int max = keys.length;
        for (int i = 0; i < max; ++i) {
            long key = keys[i];
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            hash = 31 * hash + ((int)(key >> 32) ^ (int)key);
            hash = 31 * hash + this.values[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object other) {
        long key;
        int i;
        if (!(other instanceof FastByIDMap)) {
            return false;
        }
        FastByIDMap otherMap = (FastByIDMap)other;
        long[] otherKeys = otherMap.keys;
        V[] otherValues = otherMap.values;
        int length = this.keys.length;
        int otherLength = otherKeys.length;
        int max = Math.min(length, otherLength);
        for (i = 0; i < max; ++i) {
            key = this.keys[i];
            long otherKey = otherKeys[i];
            if (!(key == Long.MIN_VALUE || key == Long.MAX_VALUE ? otherKey != Long.MIN_VALUE && otherKey != Long.MAX_VALUE : key != otherKey || !this.values[i].equals(otherValues[i]))) continue;
            return false;
        }
        while (i < length) {
            key = this.keys[i];
            if (key != Long.MIN_VALUE && key != Long.MAX_VALUE) {
                return false;
            }
            ++i;
        }
        while (i < otherLength) {
            key = otherKeys[i];
            if (key != Long.MIN_VALUE && key != Long.MAX_VALUE) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return FastByIDMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FastByIDMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return FastByIDMap.this.containsKey((Long)o);
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean add(Map.Entry<Long, V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Long, V>> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            FastByIDMap.this.clear();
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<Long, V>> {
            private int position;
            private int lastNext = -1;

            private EntryIterator() {
            }

            @Override
            public boolean hasNext() {
                this.goToNext();
                return this.position < FastByIDMap.this.keys.length;
            }

            @Override
            public Map.Entry<Long, V> next() {
                this.goToNext();
                this.lastNext = this.position;
                if (this.position >= FastByIDMap.this.keys.length) {
                    throw new NoSuchElementException();
                }
                return new MapEntry(this.position++);
            }

            private void goToNext() {
                int length = FastByIDMap.this.values.length;
                while (this.position < length && FastByIDMap.this.values[this.position] == null) {
                    ++this.position;
                }
            }

            @Override
            public void remove() {
                FastByIDMap.this.iteratorRemove(this.lastNext);
            }
        }

        private final class MapEntry
        implements Map.Entry<Long, V> {
            private final int index;

            private MapEntry(int index) {
                this.index = index;
            }

            @Override
            public Long getKey() {
                return FastByIDMap.this.keys[this.index];
            }

            @Override
            public V getValue() {
                return FastByIDMap.this.values[this.index];
            }

            @Override
            public V setValue(V value) {
                Preconditions.checkArgument((value != null ? 1 : 0) != 0);
                Object oldValue = FastByIDMap.this.values[this.index];
                ((FastByIDMap)FastByIDMap.this).values[this.index] = value;
                return oldValue;
            }
        }
    }

    private final class KeyIterator
    extends AbstractLongPrimitiveIterator {
        private int position;
        private int lastNext = -1;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goToNext();
            return this.position < FastByIDMap.this.keys.length;
        }

        @Override
        public long nextLong() {
            this.goToNext();
            this.lastNext = this.position;
            if (this.position >= FastByIDMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return FastByIDMap.this.keys[this.position++];
        }

        @Override
        public long peek() {
            this.goToNext();
            if (this.position >= FastByIDMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return FastByIDMap.this.keys[this.position];
        }

        private void goToNext() {
            int length = FastByIDMap.this.values.length;
            while (this.position < length && FastByIDMap.this.values[this.position] == null) {
                ++this.position;
            }
        }

        @Override
        public void remove() {
            FastByIDMap.this.iteratorRemove(this.lastNext);
        }

        @Override
        public void skip(int n) {
            this.position += n;
        }
    }
}

