/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.slopeone;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.EntityEntityWritable;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.cf.taste.hadoop.ToItemPrefsMapper;
import org.apache.mahout.cf.taste.hadoop.slopeone.SlopeOneDiffsToAveragesReducer;
import org.apache.mahout.cf.taste.hadoop.slopeone.SlopeOnePrefsToDiffsReducer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.VarLongWritable;

public final class SlopeOneAverageDiffsJob
extends AbstractJob {
    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        this.addInputOption();
        this.addOutputOption();
        Map<String, String> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path prefsFile = this.getInputPath();
        Path outputPath = this.getOutputPath();
        Path averagesOutputPath = new Path(parsedArgs.get("--tempDir"));
        AtomicInteger currentPhase = new AtomicInteger();
        if (SlopeOneAverageDiffsJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job prefsToDiffsJob = this.prepareJob(prefsFile, averagesOutputPath, TextInputFormat.class, ToItemPrefsMapper.class, VarLongWritable.class, EntityPrefWritable.class, SlopeOnePrefsToDiffsReducer.class, EntityEntityWritable.class, FloatWritable.class, SequenceFileOutputFormat.class);
            prefsToDiffsJob.waitForCompletion(true);
        }
        if (SlopeOneAverageDiffsJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job diffsToAveragesJob = this.prepareJob(averagesOutputPath, outputPath, SequenceFileInputFormat.class, Mapper.class, EntityEntityWritable.class, FloatWritable.class, SlopeOneDiffsToAveragesReducer.class, EntityEntityWritable.class, FloatWritable.class, TextOutputFormat.class);
            FileOutputFormat.setOutputCompressorClass((Job)diffsToAveragesJob, GzipCodec.class);
            diffsToAveragesJob.waitForCompletion(true);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SlopeOneAverageDiffsJob(), (String[])args);
    }
}

