/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.similarity.item;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.EntityEntityWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.similarity.item.ItemSimilarityJob;
import org.apache.mahout.cf.taste.hadoop.similarity.item.SimilarItem;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenIntLongHashMap;

public final class MostSimilarItemPairsMapper
extends Mapper<IntWritable, VectorWritable, EntityEntityWritable, DoubleWritable> {
    private OpenIntLongHashMap indexItemIDMap;
    private int maxSimilarItemsPerItem;

    protected void setup(Mapper.Context ctx) {
        Configuration conf = ctx.getConfiguration();
        this.maxSimilarItemsPerItem = conf.getInt(ItemSimilarityJob.MAX_SIMILARITIES_PER_ITEM, -1);
        if (this.maxSimilarItemsPerItem < 1) {
            throw new IllegalStateException("maxSimilarItemsPerItem was not correctly set!");
        }
        this.indexItemIDMap = TasteHadoopUtils.readItemIDIndexMap(conf.get(ItemSimilarityJob.ITEM_ID_INDEX_PATH_STR), conf);
    }

    protected void map(IntWritable itemIDIndexWritable, VectorWritable similarityVector, Mapper.Context ctx) throws IOException, InterruptedException {
        int itemIDIndex = itemIDIndexWritable.get();
        PriorityQueue<SimilarItem> topMostSimilarItems = new PriorityQueue<SimilarItem>(this.maxSimilarItemsPerItem + 1, Collections.reverseOrder(SimilarItem.COMPARE_BY_SIMILARITY));
        Iterator similarityVectorIterator = similarityVector.get().iterateNonZero();
        while (similarityVectorIterator.hasNext()) {
            Vector.Element element = (Vector.Element)similarityVectorIterator.next();
            int index = element.index();
            double value = element.get();
            if (index == itemIDIndex) continue;
            if (topMostSimilarItems.size() < this.maxSimilarItemsPerItem) {
                topMostSimilarItems.add(new SimilarItem(this.indexItemIDMap.get(index), value));
                continue;
            }
            if (!(value > ((SimilarItem)topMostSimilarItems.peek()).getSimilarity())) continue;
            topMostSimilarItems.add(new SimilarItem(this.indexItemIDMap.get(index), value));
            topMostSimilarItems.poll();
        }
        if (!topMostSimilarItems.isEmpty()) {
            ArrayList<SimilarItem> mostSimilarItems = new ArrayList<SimilarItem>(topMostSimilarItems.size());
            mostSimilarItems.addAll(topMostSimilarItems);
            Collections.sort(mostSimilarItems, SimilarItem.COMPARE_BY_SIMILARITY);
            long itemID = this.indexItemIDMap.get(itemIDIndex);
            for (SimilarItem similarItem : mostSimilarItems) {
                long otherItemID = similarItem.getItemID();
                if (itemID < otherItemID) {
                    ctx.write((Object)new EntityEntityWritable(itemID, otherItemID), (Object)new DoubleWritable(similarItem.getSimilarity()));
                    continue;
                }
                ctx.write((Object)new EntityEntityWritable(otherItemID, itemID), (Object)new DoubleWritable(similarItem.getSimilarity()));
            }
        }
    }
}

