/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.similarity.item;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.EntityEntityWritable;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.cf.taste.hadoop.MaybePruneRowsMapper;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.ToItemPrefsMapper;
import org.apache.mahout.cf.taste.hadoop.item.ItemIDIndexMapper;
import org.apache.mahout.cf.taste.hadoop.item.ItemIDIndexReducer;
import org.apache.mahout.cf.taste.hadoop.item.ToUserVectorReducer;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersKeyWritable;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersMapper;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersReducer;
import org.apache.mahout.cf.taste.hadoop.similarity.item.MostSimilarItemPairsMapper;
import org.apache.mahout.cf.taste.hadoop.similarity.item.MostSimilarItemPairsReducer;
import org.apache.mahout.cf.taste.hadoop.similarity.item.ToItemVectorsReducer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.similarity.RowSimilarityJob;
import org.apache.mahout.math.hadoop.similarity.SimilarityType;

public final class ItemSimilarityJob
extends AbstractJob {
    static final String ITEM_ID_INDEX_PATH_STR = ItemSimilarityJob.class.getName() + ".itemIDIndexPathStr";
    static final String MAX_SIMILARITIES_PER_ITEM = ItemSimilarityJob.class.getName() + ".maxSimilarItemsPerItem";
    private static final int DEFAULT_MAX_SIMILAR_ITEMS_PER_ITEM = 100;
    private static final int DEFAULT_MAX_COOCCURRENCES_PER_ITEM = 100;
    private static final int DEFAULT_MIN_PREFS_PER_USER = 1;

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new ItemSimilarityJob(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("similarityClassname", "s", "Name of distributed similarity class to instantiate, alternatively use one of the predefined similarities (" + SimilarityType.listEnumNames() + ')');
        this.addOption("maxSimilaritiesPerItem", "m", "try to cap the number of similar items per item to this number (default: 100)", String.valueOf(100));
        this.addOption("maxCooccurrencesPerItem", "mo", "try to cap the number of cooccurrences per item to this number (default: 100)", String.valueOf(100));
        this.addOption("minPrefsPerUser", "mp", "ignore users with less preferences than this (default: 1)", String.valueOf(1));
        this.addOption("booleanData", "b", "Treat input as without pref values", Boolean.FALSE.toString());
        Map<String, String> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        String similarityClassName = parsedArgs.get("--similarityClassname");
        int maxSimilarItemsPerItem = Integer.parseInt(parsedArgs.get("--maxSimilaritiesPerItem"));
        int maxCooccurrencesPerItem = Integer.parseInt(parsedArgs.get("--maxCooccurrencesPerItem"));
        int minPrefsPerUser = Integer.parseInt(parsedArgs.get("--minPrefsPerUser"));
        boolean booleanData = Boolean.valueOf(parsedArgs.get("--booleanData"));
        Path inputPath = this.getInputPath();
        Path outputPath = this.getOutputPath();
        Path tempDirPath = new Path(parsedArgs.get("--tempDir"));
        Path itemIDIndexPath = new Path(tempDirPath, "itemIDIndex");
        Path countUsersPath = new Path(tempDirPath, "countUsers");
        Path userVectorPath = new Path(tempDirPath, "userVectors");
        Path itemUserMatrixPath = new Path(tempDirPath, "itemUserMatrix");
        Path similarityMatrixPath = new Path(tempDirPath, "similarityMatrix");
        AtomicInteger currentPhase = new AtomicInteger();
        if (ItemSimilarityJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job itemIDIndex = this.prepareJob(inputPath, itemIDIndexPath, TextInputFormat.class, ItemIDIndexMapper.class, VarIntWritable.class, VarLongWritable.class, ItemIDIndexReducer.class, VarIntWritable.class, VarLongWritable.class, SequenceFileOutputFormat.class);
            itemIDIndex.setCombinerClass(ItemIDIndexReducer.class);
            itemIDIndex.waitForCompletion(true);
        }
        if (ItemSimilarityJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job toUserVector = this.prepareJob(inputPath, userVectorPath, TextInputFormat.class, ToItemPrefsMapper.class, VarLongWritable.class, booleanData ? VarLongWritable.class : EntityPrefWritable.class, ToUserVectorReducer.class, VarLongWritable.class, VectorWritable.class, SequenceFileOutputFormat.class);
            toUserVector.getConfiguration().setBoolean("booleanData", booleanData);
            toUserVector.getConfiguration().setInt(ToUserVectorReducer.MIN_PREFERENCES_PER_USER, minPrefsPerUser);
            toUserVector.waitForCompletion(true);
        }
        if (ItemSimilarityJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job countUsers = this.prepareJob(userVectorPath, countUsersPath, SequenceFileInputFormat.class, CountUsersMapper.class, CountUsersKeyWritable.class, VarLongWritable.class, CountUsersReducer.class, VarIntWritable.class, NullWritable.class, TextOutputFormat.class);
            countUsers.setPartitionerClass(CountUsersKeyWritable.CountUsersPartitioner.class);
            countUsers.setGroupingComparatorClass(CountUsersKeyWritable.CountUsersGroupComparator.class);
            countUsers.waitForCompletion(true);
        }
        if (ItemSimilarityJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job maybePruneAndTransponse = this.prepareJob(userVectorPath, itemUserMatrixPath, SequenceFileInputFormat.class, MaybePruneRowsMapper.class, IntWritable.class, DistributedRowMatrix.MatrixEntryWritable.class, ToItemVectorsReducer.class, IntWritable.class, VectorWritable.class, SequenceFileOutputFormat.class);
            maybePruneAndTransponse.getConfiguration().setInt(MaybePruneRowsMapper.MAX_COOCCURRENCES, maxCooccurrencesPerItem);
            maybePruneAndTransponse.waitForCompletion(true);
        }
        int numberOfUsers = TasteHadoopUtils.readIntFromFile(this.getConf(), countUsersPath);
        ToolRunner.run((Configuration)this.getConf(), (Tool)new RowSimilarityJob(), (String[])new String[]{"-Dmapred.input.dir=" + itemUserMatrixPath, "-Dmapred.output.dir=" + similarityMatrixPath, "--numberOfColumns", String.valueOf(numberOfUsers), "--similarityClassname", similarityClassName, "--maxSimilaritiesPerRow", String.valueOf(maxSimilarItemsPerItem + 1), "--tempDir", tempDirPath.toString()});
        if (ItemSimilarityJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job mostSimilarItems = this.prepareJob(similarityMatrixPath, outputPath, SequenceFileInputFormat.class, MostSimilarItemPairsMapper.class, EntityEntityWritable.class, DoubleWritable.class, MostSimilarItemPairsReducer.class, EntityEntityWritable.class, DoubleWritable.class, TextOutputFormat.class);
            Configuration mostSimilarItemsConf = mostSimilarItems.getConfiguration();
            mostSimilarItemsConf.set(ITEM_ID_INDEX_PATH_STR, itemIDIndexPath.toString());
            mostSimilarItemsConf.setInt(MAX_SIMILARITIES_PER_ITEM, maxSimilarItemsPerItem);
            mostSimilarItems.setCombinerClass(MostSimilarItemPairsReducer.class);
            mostSimilarItems.waitForCompletion(true);
        }
        return 0;
    }
}

