/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.similarity.item;

import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersKeyWritable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;

public class CountUsersReducer
extends Reducer<CountUsersKeyWritable, VarLongWritable, VarIntWritable, NullWritable> {
    protected void reduce(CountUsersKeyWritable key, Iterable<VarLongWritable> userIDs, Reducer.Context context) throws IOException, InterruptedException {
        long lastSeenUserID = Long.MIN_VALUE;
        int numberOfUsers = 0;
        for (VarLongWritable writable : userIDs) {
            long currentUserID = writable.get();
            if (currentUserID <= lastSeenUserID) continue;
            lastSeenUserID = currentUserID;
            ++numberOfUsers;
        }
        context.write((Object)new VarIntWritable(numberOfUsers), (Object)NullWritable.get());
    }
}

