/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.similarity.item;

import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Varint;

public class CountUsersKeyWritable
implements WritableComparable<CountUsersKeyWritable> {
    private long userID;

    public CountUsersKeyWritable() {
    }

    public CountUsersKeyWritable(long userID) {
        this.userID = userID;
    }

    public long getUserID() {
        return this.userID;
    }

    public void readFields(DataInput in) throws IOException {
        this.userID = Varint.readSignedVarLong(in);
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarLong(this.userID, out);
    }

    public int compareTo(CountUsersKeyWritable other) {
        return this.userID == other.userID ? 0 : (this.userID < other.userID ? -1 : 1);
    }

    public boolean equals(Object other) {
        return other instanceof CountUsersKeyWritable && this.userID == ((CountUsersKeyWritable)other).userID;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.userID);
    }

    public static class CountUsersGroupComparator
    extends WritableComparator
    implements Serializable {
        public CountUsersGroupComparator() {
            super(CountUsersKeyWritable.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            return 0;
        }
    }

    public static class CountUsersPartitioner
    extends Partitioner<CountUsersKeyWritable, VarLongWritable> {
        public int getPartition(CountUsersKeyWritable key, VarLongWritable value, int numPartitions) {
            return 0;
        }
    }
}

