/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.pseudo;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.pseudo.RecommenderReducer;
import org.apache.mahout.cf.taste.hadoop.pseudo.UserIDsMapper;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.VarLongWritable;

public final class RecommenderJob
extends AbstractJob {
    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("recommenderClassName", "r", "Name of recommender class to instantiate");
        this.addOption("numRecommendations", "n", "Number of recommendations per user", "10");
        this.addOption("usersFile", "u", "Number of recommendations per user", null);
        Map<String, String> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path inputFile = this.getInputPath();
        Path outputPath = this.getOutputPath();
        Path usersFile = parsedArgs.get("--usersFile") == null ? inputFile : new Path(parsedArgs.get("--usersFile"));
        String recommendClassName = parsedArgs.get("--recommenderClassName");
        int recommendationsPerUser = Integer.parseInt(parsedArgs.get("--numRecommendations"));
        Job job = this.prepareJob(usersFile, outputPath, TextInputFormat.class, UserIDsMapper.class, VarLongWritable.class, NullWritable.class, RecommenderReducer.class, VarLongWritable.class, RecommendedItemsWritable.class, TextOutputFormat.class);
        FileOutputFormat.setOutputCompressorClass((Job)job, GzipCodec.class);
        Configuration jobConf = job.getConfiguration();
        jobConf.set("recommenderClassName", recommendClassName);
        jobConf.setInt("recommendationsPerUser", recommendationsPerUser);
        jobConf.set("dataModelFile", inputFile.toString());
        job.waitForCompletion(true);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RecommenderJob(), (String[])args);
    }
}

