/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class VectorAndPrefsWritable
implements Writable {
    private Vector vector;
    private List<Long> userIDs;
    private List<Float> values;

    public VectorAndPrefsWritable() {
    }

    public VectorAndPrefsWritable(Vector vector, List<Long> userIDs, List<Float> values) {
        this.vector = vector;
        this.userIDs = userIDs;
        this.values = values;
    }

    public Vector getVector() {
        return this.vector;
    }

    public List<Long> getUserIDs() {
        return this.userIDs;
    }

    public List<Float> getValues() {
        return this.values;
    }

    public void write(DataOutput out) throws IOException {
        VectorWritable vw = new VectorWritable(this.vector);
        vw.setWritesLaxPrecision(true);
        vw.write(out);
        Varint.writeUnsignedVarInt(this.userIDs.size(), out);
        for (int i = 0; i < this.userIDs.size(); ++i) {
            Varint.writeSignedVarLong(this.userIDs.get(i), out);
            out.writeFloat(this.values.get(i).floatValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        VectorWritable writable = new VectorWritable();
        writable.readFields(in);
        this.vector = writable.get();
        int size = Varint.readUnsignedVarInt(in);
        this.userIDs = new ArrayList<Long>(size);
        this.values = new ArrayList<Float>(size);
        for (int i = 0; i < size; ++i) {
            this.userIDs.add(Varint.readSignedVarLong(in));
            this.values.add(Float.valueOf(in.readFloat()));
        }
    }
}

