/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.item.VectorOrPrefWritable;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class UserVectorSplitterMapper
extends Mapper<VarLongWritable, VectorWritable, VarIntWritable, VectorOrPrefWritable> {
    static final String USERS_FILE = "usersFile";
    static final String MAX_PREFS_PER_USER_CONSIDERED = "maxPrefsPerUserConsidered";
    static final int DEFAULT_MAX_PREFS_PER_USER_CONSIDERED = 10;
    private int maxPrefsPerUserConsidered;
    private FastIDSet usersToRecommendFor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(Mapper.Context context) throws IOException {
        Configuration jobConf = context.getConfiguration();
        this.maxPrefsPerUserConsidered = jobConf.getInt(MAX_PREFS_PER_USER_CONSIDERED, 10);
        String usersFilePathString = jobConf.get(USERS_FILE);
        if (usersFilePathString != null) {
            FSDataInputStream in = null;
            try {
                Path unqualifiedUsersFilePath = new Path(usersFilePathString);
                FileSystem fs = FileSystem.get((URI)unqualifiedUsersFilePath.toUri(), (Configuration)jobConf);
                this.usersToRecommendFor = new FastIDSet();
                Path usersFilePath = unqualifiedUsersFilePath.makeQualified(fs);
                in = fs.open(usersFilePath);
                for (String line : new FileLineIterable((InputStream)in)) {
                    this.usersToRecommendFor.add(Long.parseLong(line));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)in);
        }
    }

    protected void map(VarLongWritable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        long userID = key.get();
        if (this.usersToRecommendFor != null && !this.usersToRecommendFor.contains(userID)) {
            return;
        }
        Vector userVector = this.maybePruneUserVector(value.get());
        Iterator it = userVector.iterateNonZero();
        VarIntWritable itemIndexWritable = new VarIntWritable();
        VectorOrPrefWritable vectorOrPref = new VectorOrPrefWritable();
        while (it.hasNext()) {
            Vector.Element e = (Vector.Element)it.next();
            itemIndexWritable.set(e.index());
            vectorOrPref.set(userID, (float)e.get());
            context.write((Object)itemIndexWritable, (Object)vectorOrPref);
        }
    }

    private Vector maybePruneUserVector(Vector userVector) {
        if (userVector.getNumNondefaultElements() <= this.maxPrefsPerUserConsidered) {
            return userVector;
        }
        float smallestLargeValue = this.findSmallestLargeValue(userVector);
        Iterator it = userVector.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = (Vector.Element)it.next();
            float absValue = Math.abs((float)e.get());
            if (!(absValue < smallestLargeValue)) continue;
            e.set(Double.NaN);
        }
        return userVector;
    }

    private float findSmallestLargeValue(Vector userVector) {
        PriorityQueue<Float> topPrefValues = new PriorityQueue<Float>(this.maxPrefsPerUserConsidered + 1);
        Iterator it = userVector.iterateNonZero();
        while (it.hasNext()) {
            float absValue = Math.abs((float)((Vector.Element)it.next()).get());
            if (topPrefValues.size() < this.maxPrefsPerUserConsidered) {
                topPrefValues.add(Float.valueOf(absValue));
                continue;
            }
            if (!(absValue > ((Float)topPrefValues.peek()).floatValue())) continue;
            topPrefValues.add(Float.valueOf(absValue));
            topPrefValues.poll();
        }
        return ((Float)topPrefValues.peek()).floatValue();
    }
}

