/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.cf.taste.hadoop.MaybePruneRowsMapper;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.ToItemPrefsMapper;
import org.apache.mahout.cf.taste.hadoop.item.AggregateAndRecommendReducer;
import org.apache.mahout.cf.taste.hadoop.item.ItemFilterAsVectorAndPrefsReducer;
import org.apache.mahout.cf.taste.hadoop.item.ItemFilterMapper;
import org.apache.mahout.cf.taste.hadoop.item.ItemIDIndexMapper;
import org.apache.mahout.cf.taste.hadoop.item.ItemIDIndexReducer;
import org.apache.mahout.cf.taste.hadoop.item.PartialMultiplyMapper;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.hadoop.item.SimilarityMatrixRowWrapperMapper;
import org.apache.mahout.cf.taste.hadoop.item.ToUserVectorReducer;
import org.apache.mahout.cf.taste.hadoop.item.ToVectorAndPrefReducer;
import org.apache.mahout.cf.taste.hadoop.item.UserVectorSplitterMapper;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.cf.taste.hadoop.item.VectorOrPrefWritable;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersKeyWritable;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersMapper;
import org.apache.mahout.cf.taste.hadoop.similarity.item.CountUsersReducer;
import org.apache.mahout.cf.taste.hadoop.similarity.item.ToItemVectorsReducer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.similarity.RowSimilarityJob;
import org.apache.mahout.math.hadoop.similarity.SimilarityType;

public final class RecommenderJob
extends AbstractJob {
    public static final String BOOLEAN_DATA = "booleanData";
    private static final int DEFAULT_MAX_SIMILARITIES_PER_ITEM = 100;
    private static final int DEFAULT_MAX_COOCCURRENCES_PER_ITEM = 100;
    private static final int DEFAULT_MIN_PREFS_PER_USER = 1;

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        this.addInputOption();
        this.addOutputOption();
        this.addOption("numRecommendations", "n", "Number of recommendations per user", String.valueOf(10));
        this.addOption("usersFile", "u", "File of users to recommend for", null);
        this.addOption("itemsFile", "i", "File of items to recommend for", null);
        this.addOption("filterFile", "f", "File containing comma-separated userID,itemID pairs. Used to exclude the item from the recommendations for that user (optional)", null);
        this.addOption(BOOLEAN_DATA, "b", "Treat input as without pref values", Boolean.FALSE.toString());
        this.addOption("maxPrefsPerUser", "mp", "Maximum number of preferences considered per user in final recommendation phase", String.valueOf(10));
        this.addOption("minPrefsPerUser", "mp", "ignore users with less preferences than this in the similarity computation (default: 1)", String.valueOf(1));
        this.addOption("maxSimilaritiesPerItem", "m", "Maximum number of similarities considered per item ", String.valueOf(100));
        this.addOption("maxCooccurrencesPerItem", "mo", "try to cap the number of cooccurrences per item to this number (default: 100)", String.valueOf(100));
        this.addOption("similarityClassname", "s", "Name of distributed similarity class to instantiate, alternatively use one of the predefined similarities (" + SimilarityType.listEnumNames() + ')', String.valueOf((Object)SimilarityType.SIMILARITY_COOCCURRENCE));
        Map<String, String> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path inputPath = this.getInputPath();
        Path outputPath = this.getOutputPath();
        Path tempDirPath = new Path(parsedArgs.get("--tempDir"));
        int numRecommendations = Integer.parseInt(parsedArgs.get("--numRecommendations"));
        String usersFile = parsedArgs.get("--usersFile");
        String itemsFile = parsedArgs.get("--itemsFile");
        String filterFile = parsedArgs.get("--filterFile");
        boolean booleanData = Boolean.valueOf(parsedArgs.get("--booleanData"));
        int maxPrefsPerUser = Integer.parseInt(parsedArgs.get("--maxPrefsPerUser"));
        int minPrefsPerUser = Integer.parseInt(parsedArgs.get("--minPrefsPerUser"));
        int maxSimilaritiesPerItem = Integer.parseInt(parsedArgs.get("--maxSimilaritiesPerItem"));
        int maxCooccurrencesPerItem = Integer.parseInt(parsedArgs.get("--maxCooccurrencesPerItem"));
        String similarityClassname = parsedArgs.get("--similarityClassname");
        Path userVectorPath = new Path(tempDirPath, "userVectors");
        Path itemIDIndexPath = new Path(tempDirPath, "itemIDIndex");
        Path countUsersPath = new Path(tempDirPath, "countUsers");
        Path itemUserMatrixPath = new Path(tempDirPath, "itemUserMatrix");
        Path similarityMatrixPath = new Path(tempDirPath, "similarityMatrix");
        Path prePartialMultiplyPath1 = new Path(tempDirPath, "prePartialMultiply1");
        Path prePartialMultiplyPath2 = new Path(tempDirPath, "prePartialMultiply2");
        Path explicitFilterPath = new Path(tempDirPath, "explicitFilterPath");
        Path partialMultiplyPath = new Path(tempDirPath, "partialMultiply");
        AtomicInteger currentPhase = new AtomicInteger();
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job itemIDIndex = this.prepareJob(inputPath, itemIDIndexPath, TextInputFormat.class, ItemIDIndexMapper.class, VarIntWritable.class, VarLongWritable.class, ItemIDIndexReducer.class, VarIntWritable.class, VarLongWritable.class, SequenceFileOutputFormat.class);
            itemIDIndex.setCombinerClass(ItemIDIndexReducer.class);
            itemIDIndex.waitForCompletion(true);
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job toUserVector = this.prepareJob(inputPath, userVectorPath, TextInputFormat.class, ToItemPrefsMapper.class, VarLongWritable.class, booleanData ? VarLongWritable.class : EntityPrefWritable.class, ToUserVectorReducer.class, VarLongWritable.class, VectorWritable.class, SequenceFileOutputFormat.class);
            toUserVector.getConfiguration().setBoolean(BOOLEAN_DATA, booleanData);
            toUserVector.getConfiguration().setInt(ToUserVectorReducer.MIN_PREFERENCES_PER_USER, minPrefsPerUser);
            toUserVector.waitForCompletion(true);
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job countUsers = this.prepareJob(userVectorPath, countUsersPath, SequenceFileInputFormat.class, CountUsersMapper.class, CountUsersKeyWritable.class, VarLongWritable.class, CountUsersReducer.class, VarIntWritable.class, NullWritable.class, TextOutputFormat.class);
            countUsers.setPartitionerClass(CountUsersKeyWritable.CountUsersPartitioner.class);
            countUsers.setGroupingComparatorClass(CountUsersKeyWritable.CountUsersGroupComparator.class);
            countUsers.waitForCompletion(true);
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job maybePruneAndTransponse = this.prepareJob(userVectorPath, itemUserMatrixPath, SequenceFileInputFormat.class, MaybePruneRowsMapper.class, IntWritable.class, DistributedRowMatrix.MatrixEntryWritable.class, ToItemVectorsReducer.class, IntWritable.class, VectorWritable.class, SequenceFileOutputFormat.class);
            maybePruneAndTransponse.getConfiguration().setInt(MaybePruneRowsMapper.MAX_COOCCURRENCES, maxCooccurrencesPerItem);
            maybePruneAndTransponse.waitForCompletion(true);
        }
        int numberOfUsers = TasteHadoopUtils.readIntFromFile(this.getConf(), countUsersPath);
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            try {
                ToolRunner.run((Configuration)this.getConf(), (Tool)new RowSimilarityJob(), (String[])new String[]{"-Dmapred.input.dir=" + itemUserMatrixPath, "-Dmapred.output.dir=" + similarityMatrixPath, "--numberOfColumns", String.valueOf(numberOfUsers), "--similarityClassname", similarityClassname, "--maxSimilaritiesPerRow", String.valueOf(maxSimilaritiesPerItem + 1), "--tempDir", tempDirPath.toString()});
            }
            catch (Exception e) {
                throw new IllegalStateException("item-item-similarity computation failed", e);
            }
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            Job prePartialMultiply1 = this.prepareJob(similarityMatrixPath, prePartialMultiplyPath1, SequenceFileInputFormat.class, SimilarityMatrixRowWrapperMapper.class, VarIntWritable.class, VectorOrPrefWritable.class, Reducer.class, VarIntWritable.class, VectorOrPrefWritable.class, SequenceFileOutputFormat.class);
            prePartialMultiply1.waitForCompletion(true);
            Job prePartialMultiply2 = this.prepareJob(userVectorPath, prePartialMultiplyPath2, SequenceFileInputFormat.class, UserVectorSplitterMapper.class, VarIntWritable.class, VectorOrPrefWritable.class, Reducer.class, VarIntWritable.class, VectorOrPrefWritable.class, SequenceFileOutputFormat.class);
            if (usersFile != null) {
                prePartialMultiply2.getConfiguration().set("usersFile", usersFile);
            }
            prePartialMultiply2.getConfiguration().setInt("maxPrefsPerUserConsidered", maxPrefsPerUser);
            prePartialMultiply2.waitForCompletion(true);
            Job partialMultiply = this.prepareJob(new Path(prePartialMultiplyPath1 + "," + prePartialMultiplyPath2), partialMultiplyPath, SequenceFileInputFormat.class, Mapper.class, VarIntWritable.class, VectorOrPrefWritable.class, ToVectorAndPrefReducer.class, VarIntWritable.class, VectorAndPrefsWritable.class, SequenceFileOutputFormat.class);
            Configuration partialMultiplyConf = partialMultiply.getConfiguration();
            FileSystem fs = FileSystem.get((URI)tempDirPath.toUri(), (Configuration)partialMultiplyConf);
            prePartialMultiplyPath1 = prePartialMultiplyPath1.makeQualified(fs);
            prePartialMultiplyPath2 = prePartialMultiplyPath2.makeQualified(fs);
            FileInputFormat.setInputPaths((Job)partialMultiply, (Path[])new Path[]{prePartialMultiplyPath1, prePartialMultiplyPath2});
            partialMultiply.waitForCompletion(true);
        }
        if (RecommenderJob.shouldRunNextPhase(parsedArgs, currentPhase)) {
            if (filterFile != null) {
                Job itemFiltering = this.prepareJob(new Path(filterFile), explicitFilterPath, TextInputFormat.class, ItemFilterMapper.class, VarLongWritable.class, VarLongWritable.class, ItemFilterAsVectorAndPrefsReducer.class, VarIntWritable.class, VectorAndPrefsWritable.class, SequenceFileOutputFormat.class);
                itemFiltering.waitForCompletion(true);
            }
            String aggregateAndRecommendInput = partialMultiplyPath.toString();
            if (filterFile != null) {
                aggregateAndRecommendInput = aggregateAndRecommendInput + "," + explicitFilterPath;
            }
            Job aggregateAndRecommend = this.prepareJob(new Path(aggregateAndRecommendInput), outputPath, SequenceFileInputFormat.class, PartialMultiplyMapper.class, VarLongWritable.class, PrefAndSimilarityColumnWritable.class, AggregateAndRecommendReducer.class, VarLongWritable.class, RecommendedItemsWritable.class, TextOutputFormat.class);
            Configuration aggregateAndRecommendConf = aggregateAndRecommend.getConfiguration();
            if (itemsFile != null) {
                aggregateAndRecommendConf.set("itemsFile", itemsFile);
            }
            if (filterFile != null) {
                FileSystem fs = FileSystem.get((URI)tempDirPath.toUri(), (Configuration)aggregateAndRecommendConf);
                partialMultiplyPath = partialMultiplyPath.makeQualified(fs);
                explicitFilterPath = explicitFilterPath.makeQualified(fs);
                FileInputFormat.setInputPaths((Job)aggregateAndRecommend, (Path[])new Path[]{partialMultiplyPath, explicitFilterPath});
            }
            RecommenderJob.setIOSort((JobContext)aggregateAndRecommend);
            aggregateAndRecommendConf.set("itemIDIndexPath", itemIDIndexPath.toString());
            aggregateAndRecommendConf.setInt("numRecommendations", numRecommendations);
            aggregateAndRecommendConf.setBoolean(BOOLEAN_DATA, booleanData);
            aggregateAndRecommend.waitForCompletion(true);
        }
        return 0;
    }

    private static void setIOSort(JobContext job) {
        Matcher m;
        Configuration conf = job.getConfiguration();
        conf.setInt("io.sort.factor", 100);
        int assumedHeapSize = 512;
        String javaOpts = conf.get("mapred.child.java.opts");
        if (javaOpts != null && (m = Pattern.compile("-Xmx([0-9]+)([mMgG])").matcher(javaOpts)).find()) {
            assumedHeapSize = Integer.parseInt(m.group(1));
            String megabyteOrGigabyte = m.group(2);
            if ("g".equalsIgnoreCase(megabyteOrGigabyte)) {
                assumedHeapSize *= 1024;
            }
        }
        conf.setInt("io.sort.mb", assumedHeapSize / 2);
        conf.setInt("mapred.task.timeout", 3600000);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new RecommenderJob(), (String[])args);
    }
}

