/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;

public final class ItemIDIndexMapper
extends Mapper<LongWritable, Text, VarIntWritable, VarLongWritable> {
    private boolean transpose;

    protected void setup(Mapper.Context context) {
        Configuration jobConf = context.getConfiguration();
        this.transpose = jobConf.getBoolean("transposeUserItem", false);
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String[] tokens = TasteHadoopUtils.splitPrefTokens(value.toString());
        long itemID = Long.parseLong(tokens[this.transpose ? 0 : 1]);
        int index = TasteHadoopUtils.idToIndex(itemID);
        context.write((Object)new VarIntWritable(index), (Object)new VarLongWritable(itemID));
    }
}

