/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.item.VectorAndPrefsWritable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;

public class ItemFilterAsVectorAndPrefsReducer
extends Reducer<VarLongWritable, VarLongWritable, VarIntWritable, VectorAndPrefsWritable> {
    protected void reduce(VarLongWritable itemID, Iterable<VarLongWritable> values, Reducer.Context ctx) throws IOException, InterruptedException {
        int itemIDIndex = TasteHadoopUtils.idToIndex(itemID.get());
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE, 1);
        vector.set(itemIDIndex, Double.NaN);
        ArrayList<Long> userIDs = new ArrayList<Long>();
        ArrayList<Float> prefValues = new ArrayList<Float>();
        for (VarLongWritable userID : values) {
            userIDs.add(userID.get());
            prefValues.add(Float.valueOf(1.0f));
        }
        ctx.write((Object)new VarIntWritable(itemIDIndex), (Object)new VectorAndPrefsWritable((Vector)vector, userIDs, prefValues));
    }
}

