/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.ByValueRecommendedItemComparator;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.map.OpenIntLongHashMap;

public final class AggregateAndRecommendReducer
extends Reducer<VarLongWritable, PrefAndSimilarityColumnWritable, VarLongWritable, RecommendedItemsWritable> {
    static final String ITEMID_INDEX_PATH = "itemIDIndexPath";
    static final String NUM_RECOMMENDATIONS = "numRecommendations";
    static final int DEFAULT_NUM_RECOMMENDATIONS = 10;
    static final String ITEMS_FILE = "itemsFile";
    private boolean booleanData;
    private int recommendationsPerUser;
    private FastIDSet itemsToRecommendFor;
    private OpenIntLongHashMap indexItemIDMap;
    private static final float BOOLEAN_PREF_VALUE = 1.0f;
    private static final DoubleFunction ABSOLUTE_VALUES = new DoubleFunction(){

        public double apply(double value) {
            return value < 0.0 ? value * -1.0 : value;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(Reducer.Context context) throws IOException {
        Configuration jobConf = context.getConfiguration();
        this.recommendationsPerUser = jobConf.getInt(NUM_RECOMMENDATIONS, 10);
        this.booleanData = jobConf.getBoolean("booleanData", false);
        this.indexItemIDMap = TasteHadoopUtils.readItemIDIndexMap(jobConf.get(ITEMID_INDEX_PATH), jobConf);
        FSDataInputStream in = null;
        try {
            String itemFilePathString = jobConf.get(ITEMS_FILE);
            if (itemFilePathString == null) {
                this.itemsToRecommendFor = null;
            } else {
                Path unqualifiedItemsFilePath = new Path(itemFilePathString);
                FileSystem fs = FileSystem.get((URI)unqualifiedItemsFilePath.toUri(), (Configuration)jobConf);
                this.itemsToRecommendFor = new FastIDSet();
                Path itemsFilePath = unqualifiedItemsFilePath.makeQualified(fs);
                in = fs.open(itemsFilePath);
                for (String line : new FileLineIterable((InputStream)in)) {
                    this.itemsToRecommendFor.add(Long.parseLong(line));
                }
            }
        }
        finally {
            IOUtils.closeStream(in);
        }
    }

    protected void reduce(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (this.booleanData) {
            this.reduceBooleanData(userID, values, context);
        } else {
            this.reduceNonBooleanData(userID, values, context);
        }
    }

    private void reduceBooleanData(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Vector predictionVector = null;
        for (PrefAndSimilarityColumnWritable prefAndSimilarityColumn : values) {
            predictionVector = predictionVector == null ? prefAndSimilarityColumn.getSimilarityColumn() : predictionVector.plus(prefAndSimilarityColumn.getSimilarityColumn());
        }
        this.writeRecommendedItems(userID, predictionVector, context);
    }

    private void reduceNonBooleanData(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Vector numerators = null;
        Vector denominators = null;
        RandomAccessSparseVector numberOfSimilarItemsUsed = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        for (PrefAndSimilarityColumnWritable prefAndSimilarityColumn : values) {
            Vector simColumn = prefAndSimilarityColumn.getSimilarityColumn();
            float prefValue = prefAndSimilarityColumn.getPrefValue();
            Iterator usedItemsIterator = simColumn.iterateNonZero();
            while (usedItemsIterator.hasNext()) {
                int itemIDIndex = ((Vector.Element)usedItemsIterator.next()).index();
                numberOfSimilarItemsUsed.setQuick(itemIDIndex, numberOfSimilarItemsUsed.getQuick(itemIDIndex) + 1.0);
            }
            numerators = numerators == null ? (prefValue == 1.0f ? simColumn.clone() : simColumn.times((double)prefValue)) : numerators.plus(prefValue == 1.0f ? simColumn : simColumn.times((double)prefValue));
            simColumn.assign(ABSOLUTE_VALUES);
            denominators = denominators == null ? simColumn : denominators.plus(simColumn);
        }
        if (numerators == null) {
            return;
        }
        RandomAccessSparseVector recommendationVector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        Iterator iterator = numerators.iterateNonZero();
        while (iterator.hasNext()) {
            Vector.Element element = (Vector.Element)iterator.next();
            int itemIDIndex = element.index();
            if (!(numberOfSimilarItemsUsed.getQuick(itemIDIndex) > 1.0)) continue;
            double prediction = element.get() / denominators.getQuick(itemIDIndex);
            recommendationVector.setQuick(itemIDIndex, prediction);
        }
        this.writeRecommendedItems(userID, (Vector)recommendationVector, context);
    }

    private void writeRecommendedItems(VarLongWritable userID, Vector recommendationVector, Reducer.Context context) throws IOException, InterruptedException {
        PriorityQueue<RecommendedItem> topItems = new PriorityQueue<RecommendedItem>(this.recommendationsPerUser + 1, Collections.reverseOrder(ByValueRecommendedItemComparator.getInstance()));
        Iterator recommendationVectorIterator = recommendationVector.iterateNonZero();
        while (recommendationVectorIterator.hasNext()) {
            float value;
            Vector.Element element = (Vector.Element)recommendationVectorIterator.next();
            int index = element.index();
            long itemID = this.indexItemIDMap.get(index);
            if (this.itemsToRecommendFor != null && !this.itemsToRecommendFor.contains(itemID) || Float.isNaN(value = (float)element.get())) continue;
            if (topItems.size() < this.recommendationsPerUser) {
                topItems.add(new GenericRecommendedItem(itemID, value));
                continue;
            }
            if (!(value > ((RecommendedItem)topItems.peek()).getValue())) continue;
            topItems.add(new GenericRecommendedItem(itemID, value));
            topItems.poll();
        }
        if (!topItems.isEmpty()) {
            ArrayList<RecommendedItem> recommendations = new ArrayList<RecommendedItem>(topItems.size());
            recommendations.addAll(topItems);
            Collections.sort(recommendations, ByValueRecommendedItemComparator.getInstance());
            context.write((Object)userID, (Object)new RecommendedItemsWritable(recommendations));
        }
    }
}

