/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class VectorWithIndexWritable
implements Writable {
    private Vector vector;
    private Integer idIndex;

    public VectorWithIndexWritable() {
    }

    public VectorWithIndexWritable(Vector vector) {
        this.vector = vector;
    }

    public VectorWithIndexWritable(int idIndex) {
        this.idIndex = idIndex;
    }

    public VectorWithIndexWritable(Integer idIndex, Vector vector) {
        this.vector = vector;
        this.idIndex = idIndex;
    }

    public Vector getVector() {
        return this.vector;
    }

    public int getIDIndex() {
        return this.idIndex;
    }

    public boolean hasVector() {
        return this.vector != null;
    }

    public boolean hasIndex() {
        return this.idIndex != null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.hasVector());
        if (this.hasVector()) {
            new VectorWritable(this.vector).write(out);
        }
        out.writeBoolean(this.hasIndex());
        if (this.hasIndex()) {
            Varint.writeSignedVarInt(this.idIndex, out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        boolean hasRating;
        this.vector = null;
        this.idIndex = null;
        boolean hasVector = in.readBoolean();
        if (hasVector) {
            VectorWritable writable = new VectorWritable();
            writable.readFields(in);
            this.vector = writable.get();
        }
        if (hasRating = in.readBoolean()) {
            this.idIndex = Varint.readSignedVarInt(in);
        }
    }
}

