/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.mahout.math.Varint;

public class TaggedVarIntWritable
implements WritableComparable<TaggedVarIntWritable> {
    private int value;
    private boolean tagged;

    public TaggedVarIntWritable() {
    }

    public TaggedVarIntWritable(int value, boolean tagged) {
        this.value = value;
        this.tagged = tagged;
    }

    public int get() {
        return this.value;
    }

    public int compareTo(TaggedVarIntWritable other) {
        return this.value == other.value ? 0 : (this.value < other.value ? -1 : 1);
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.tagged);
        Varint.writeSignedVarInt(this.value, out);
    }

    public void readFields(DataInput in) throws IOException {
        this.tagged = in.readBoolean();
        this.value = Varint.readSignedVarInt(in);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof TaggedVarIntWritable) {
            TaggedVarIntWritable other = (TaggedVarIntWritable)o;
            return this.value == other.value;
        }
        return false;
    }

    static {
        WritableComparator.define(TaggedVarIntWritable.class, (WritableComparator)new SecondarySortComparator());
    }

    public static class GroupingComparator
    extends WritableComparator
    implements Serializable {
        protected GroupingComparator() {
            super(TaggedVarIntWritable.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            return a.compareTo((Object)b);
        }
    }

    public static class SecondarySortComparator
    extends WritableComparator
    implements Serializable {
        protected SecondarySortComparator() {
            super(TaggedVarIntWritable.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            TaggedVarIntWritable first = (TaggedVarIntWritable)a;
            TaggedVarIntWritable second = (TaggedVarIntWritable)b;
            int result = SecondarySortComparator.compare(first.value, second.value);
            if (result == 0) {
                if (first.tagged && !second.tagged) {
                    return -1;
                }
                if (!first.tagged && second.tagged) {
                    return 1;
                }
            }
            return result;
        }

        protected static int compare(int a, int b) {
            return a == b ? 0 : (a < b ? -1 : 1);
        }
    }
}

