/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.als.TaggedVarIntWritable;
import org.apache.mahout.cf.taste.hadoop.als.VectorWithIndexWritable;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class PredictionJob
extends AbstractJob {
    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new PredictionJob(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addOption("pairs", "p", "path containing the test ratings, each line must be: userID,itemID", true);
        this.addOption("userFeatures", "u", "path to the user feature matrix", true);
        this.addOption("itemFeatures", "i", "path to the item feature matrix", true);
        this.addOutputOption();
        Map<String, String> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path pairs = new Path(parsedArgs.get("--pairs"));
        Path userFeatures = new Path(parsedArgs.get("--userFeatures"));
        Path itemFeatures = new Path(parsedArgs.get("--itemFeatures"));
        Path tempDirPath = new Path(parsedArgs.get("--tempDir"));
        Path convertedPairs = new Path(tempDirPath, "convertedPairs");
        Path convertedUserFeatures = new Path(tempDirPath, "convertedUserFeatures");
        Path convertedItemFeatures = new Path(tempDirPath, "convertedItemFeatures");
        Path pairsJoinedWithItemFeatures = new Path(tempDirPath, "pairsJoinedWithItemFeatures");
        Job convertPairs = this.prepareJob(pairs, convertedPairs, TextInputFormat.class, PairsMapper.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, Reducer.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, SequenceFileOutputFormat.class);
        convertPairs.waitForCompletion(true);
        Job convertUserFeatures = this.prepareJob(userFeatures, convertedUserFeatures, SequenceFileInputFormat.class, FeaturesMapper.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, Reducer.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, SequenceFileOutputFormat.class);
        convertUserFeatures.waitForCompletion(true);
        Job convertItemFeatures = this.prepareJob(itemFeatures, convertedItemFeatures, SequenceFileInputFormat.class, FeaturesMapper.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, Reducer.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, SequenceFileOutputFormat.class);
        convertItemFeatures.waitForCompletion(true);
        Job joinPairsWithItemFeatures = this.prepareJob(new Path(convertedPairs + "," + convertedItemFeatures), pairsJoinedWithItemFeatures, SequenceFileInputFormat.class, Mapper.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, JoinProbesWithItemFeaturesReducer.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, SequenceFileOutputFormat.class);
        joinPairsWithItemFeatures.setPartitionerClass(HashPartitioner.class);
        joinPairsWithItemFeatures.setGroupingComparatorClass(TaggedVarIntWritable.GroupingComparator.class);
        joinPairsWithItemFeatures.waitForCompletion(true);
        Job predictRatings = this.prepareJob(new Path(pairsJoinedWithItemFeatures + "," + convertedUserFeatures), this.getOutputPath(), SequenceFileInputFormat.class, Mapper.class, TaggedVarIntWritable.class, VectorWithIndexWritable.class, PredictRatingReducer.class, Text.class, NullWritable.class, TextOutputFormat.class);
        predictRatings.setPartitionerClass(HashPartitioner.class);
        predictRatings.setGroupingComparatorClass(TaggedVarIntWritable.GroupingComparator.class);
        predictRatings.waitForCompletion(true);
        return 0;
    }

    public static class PredictRatingReducer
    extends Reducer<TaggedVarIntWritable, VectorWithIndexWritable, Text, NullWritable> {
        protected void reduce(TaggedVarIntWritable key, Iterable<VectorWithIndexWritable> values, Reducer.Context ctx) throws IOException, InterruptedException {
            Vector userFeatures = null;
            int userIDIndex = key.get();
            for (VectorWithIndexWritable vectorWithIndexWritable : values) {
                if (userFeatures == null && vectorWithIndexWritable.getVector() != null) {
                    userFeatures = vectorWithIndexWritable.getVector();
                    continue;
                }
                if (userFeatures == null && vectorWithIndexWritable.getVector() == null) {
                    return;
                }
                int itemIDIndex = vectorWithIndexWritable.getIDIndex();
                Vector itemFeatures = vectorWithIndexWritable.getVector();
                double estimatedPrediction = userFeatures.dot(itemFeatures);
                ctx.write((Object)new Text(userIDIndex + "," + itemIDIndex + ',' + estimatedPrediction), (Object)NullWritable.get());
            }
        }
    }

    public static class JoinProbesWithItemFeaturesReducer
    extends Reducer<TaggedVarIntWritable, VectorWithIndexWritable, TaggedVarIntWritable, VectorWithIndexWritable> {
        protected void reduce(TaggedVarIntWritable key, Iterable<VectorWithIndexWritable> values, Reducer.Context ctx) throws IOException, InterruptedException {
            int itemIDIndex = key.get();
            Vector itemFeatures = null;
            for (VectorWithIndexWritable vectorWithIndexWritable : values) {
                if (itemFeatures == null && vectorWithIndexWritable.getVector() != null) {
                    itemFeatures = vectorWithIndexWritable.getVector();
                    continue;
                }
                if (itemFeatures == null && vectorWithIndexWritable.getVector() == null) {
                    return;
                }
                int userIDIndex = vectorWithIndexWritable.getIDIndex();
                ctx.write((Object)new TaggedVarIntWritable(userIDIndex, false), (Object)new VectorWithIndexWritable(itemIDIndex, itemFeatures));
            }
        }
    }

    public static class FeaturesMapper
    extends Mapper<IntWritable, VectorWritable, TaggedVarIntWritable, VectorWithIndexWritable> {
        protected void map(IntWritable id, VectorWritable features, Mapper.Context ctx) throws IOException, InterruptedException {
            ctx.write((Object)new TaggedVarIntWritable(id.get(), true), (Object)new VectorWithIndexWritable(features.get()));
        }
    }

    public static class PairsMapper
    extends Mapper<LongWritable, Text, TaggedVarIntWritable, VectorWithIndexWritable> {
        protected void map(LongWritable key, Text value, Mapper.Context ctx) throws IOException, InterruptedException {
            String[] tokens = TasteHadoopUtils.splitPrefTokens(value.toString());
            int userIDIndex = TasteHadoopUtils.idToIndex(Long.parseLong(tokens[0]));
            int itemIDIndex = TasteHadoopUtils.idToIndex(Long.parseLong(tokens[1]));
            ctx.write((Object)new TaggedVarIntWritable(itemIDIndex, false), (Object)new VectorWithIndexWritable(userIDIndex));
        }
    }
}

