/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.mahout.math.Varint;

public class IndexedVarIntWritable
implements WritableComparable<IndexedVarIntWritable> {
    private int value;
    private int index;

    public IndexedVarIntWritable() {
    }

    public IndexedVarIntWritable(int value, int index) {
        this.value = value;
        this.index = index;
    }

    public int getValue() {
        return this.value;
    }

    public int compareTo(IndexedVarIntWritable other) {
        return this.value == other.value ? 0 : (this.value < other.value ? -1 : 1);
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarInt(this.value, out);
        Varint.writeSignedVarInt(this.index, out);
    }

    public void readFields(DataInput in) throws IOException {
        this.value = Varint.readSignedVarInt(in);
        this.index = Varint.readSignedVarInt(in);
    }

    public boolean equals(Object o) {
        if (o instanceof IndexedVarIntWritable) {
            return this.value == ((IndexedVarIntWritable)o).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        WritableComparator.define(IndexedVarIntWritable.class, (WritableComparator)new SecondarySortComparator());
    }

    public static class GroupingComparator
    extends WritableComparator
    implements Serializable {
        protected GroupingComparator() {
            super(IndexedVarIntWritable.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            return a.compareTo((Object)b);
        }
    }

    public static class SecondarySortComparator
    extends WritableComparator
    implements Serializable {
        protected SecondarySortComparator() {
            super(IndexedVarIntWritable.class, true);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            IndexedVarIntWritable first = (IndexedVarIntWritable)a;
            IndexedVarIntWritable second = (IndexedVarIntWritable)b;
            int result = SecondarySortComparator.compare(first.value, second.value);
            if (result == 0) {
                result = SecondarySortComparator.compare(first.index, second.index);
            }
            return result;
        }

        protected static int compare(int a, int b) {
            return a == b ? 0 : (a < b ? -1 : 1);
        }
    }
}

