/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class FeatureVectorWithRatingWritable
implements Writable,
Cloneable {
    private int idIndex;
    private Float rating;
    private Vector vector;

    public FeatureVectorWithRatingWritable() {
    }

    public FeatureVectorWithRatingWritable(int idIndex, Float rating, Vector featureVector) {
        this.idIndex = idIndex;
        this.rating = rating;
        this.vector = featureVector;
    }

    public FeatureVectorWithRatingWritable(int idIndex, Vector featureVector) {
        this.idIndex = idIndex;
        this.vector = featureVector;
    }

    public FeatureVectorWithRatingWritable(int idIndex, float rating) {
        this.idIndex = idIndex;
        this.rating = Float.valueOf(rating);
    }

    public boolean containsFeatureVector() {
        return this.vector != null;
    }

    public boolean containsRating() {
        return this.rating != null;
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(this.idIndex, out);
        boolean containsRating = this.containsRating();
        out.writeBoolean(containsRating);
        if (containsRating) {
            out.writeFloat(this.rating.floatValue());
        }
        boolean containsFeatureVector = this.containsFeatureVector();
        out.writeBoolean(containsFeatureVector);
        if (containsFeatureVector) {
            VectorWritable.writeVector(out, this.vector);
        }
    }

    public void readFields(DataInput in) throws IOException {
        boolean containsFeatureVector;
        this.rating = null;
        this.vector = null;
        this.idIndex = Varint.readUnsignedVarInt(in);
        boolean containsRating = in.readBoolean();
        if (containsRating) {
            this.rating = Float.valueOf(in.readFloat());
        }
        if (containsFeatureVector = in.readBoolean()) {
            VectorWritable vw = new VectorWritable();
            vw.readFields(in);
            this.vector = vw.get();
        }
    }

    public int getIDIndex() {
        return this.idIndex;
    }

    public Float getRating() {
        return this.rating;
    }

    public Vector getFeatureVector() {
        return this.vector;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeatureVectorWithRatingWritable)) {
            return false;
        }
        FeatureVectorWithRatingWritable other = (FeatureVectorWithRatingWritable)o;
        if (this.idIndex != other.idIndex) {
            return false;
        }
        if (this.rating != null ? !this.rating.equals(other.rating) : other.rating != null) {
            return false;
        }
        return !(this.vector != null ? !this.vector.equals(other.vector) : other.vector != null);
    }

    public int hashCode() {
        int result = 31 * this.idIndex + (this.rating != null ? this.rating.hashCode() : 0);
        result = 31 * result + (this.vector != null ? this.vector.hashCode() : 0);
        return result;
    }

    protected FeatureVectorWithRatingWritable clone() {
        return new FeatureVectorWithRatingWritable(this.idIndex, this.rating, this.vector);
    }
}

