/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.math.VarLongWritable;

public abstract class ToEntityPrefsMapper
extends Mapper<LongWritable, Text, VarLongWritable, VarLongWritable> {
    public static final String TRANSPOSE_USER_ITEM = "transposeUserItem";
    private static final Pattern DELIMITER = Pattern.compile("[\t,]");
    private boolean booleanData;
    private boolean transpose;
    private final boolean itemKey;

    ToEntityPrefsMapper(boolean itemKey) {
        this.itemKey = itemKey;
    }

    protected void setup(Mapper.Context context) {
        Configuration jobConf = context.getConfiguration();
        this.booleanData = jobConf.getBoolean("booleanData", false);
        this.transpose = jobConf.getBoolean(TRANSPOSE_USER_ITEM, false);
    }

    public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        String[] tokens = DELIMITER.split(value.toString());
        long userID = Long.parseLong(tokens[0]);
        long itemID = Long.parseLong(tokens[1]);
        if (this.itemKey ^ this.transpose) {
            long temp = userID;
            userID = itemID;
            itemID = temp;
        }
        if (this.booleanData) {
            context.write((Object)new VarLongWritable(userID), (Object)new VarLongWritable(itemID));
        } else {
            float prefValue = tokens.length > 2 ? Float.parseFloat(tokens[2]) : 1.0f;
            context.write((Object)new VarLongWritable(userID), (Object)new EntityPrefWritable(itemID, prefValue));
        }
    }
}

