/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import com.google.common.base.Charsets;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.map.OpenIntLongHashMap;

public final class TasteHadoopUtils {
    private static final Pattern PREFERENCE_TOKEN_DELIMITER = Pattern.compile("[\t,]");

    private TasteHadoopUtils() {
    }

    public static String[] splitPrefTokens(CharSequence line) {
        return PREFERENCE_TOKEN_DELIMITER.split(line);
    }

    public static int idToIndex(long id) {
        return Integer.MAX_VALUE & Longs.hashCode((long)id);
    }

    public static OpenIntLongHashMap readItemIDIndexMap(String itemIDIndexPathStr, Configuration conf) {
        OpenIntLongHashMap indexItemIDMap = new OpenIntLongHashMap();
        Path itemIDIndexPath = new Path(itemIDIndexPathStr);
        for (Pair record : new SequenceFileDirIterable(itemIDIndexPath, PathType.LIST, PathFilters.partFilter(), null, true, conf)) {
            indexItemIDMap.put(((VarIntWritable)record.getFirst()).get(), ((VarLongWritable)record.getSecond()).get());
        }
        return indexItemIDMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readIntFromFile(Configuration conf, Path outputDir) throws IOException {
        FileSystem fs = outputDir.getFileSystem(conf);
        Path outputFile = fs.listStatus(outputDir, PathFilters.partFilter())[0].getPath();
        FSDataInputStream in = null;
        try {
            in = fs.open(outputFile);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf);
            int n = Integer.parseInt(new String(out.toByteArray(), Charsets.UTF_8).trim());
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
    }
}

