/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.math.Varint;

public final class RecommendedItemsWritable
implements Writable {
    private List<RecommendedItem> recommended;

    public RecommendedItemsWritable() {
    }

    public RecommendedItemsWritable(List<RecommendedItem> recommended) {
        this.recommended = recommended;
    }

    public List<RecommendedItem> getRecommendedItems() {
        return this.recommended;
    }

    public void set(List<RecommendedItem> recommended) {
        this.recommended = recommended;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.recommended.size());
        for (RecommendedItem item : this.recommended) {
            Varint.writeSignedVarLong(item.getItemID(), out);
            out.writeFloat(item.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.recommended = new ArrayList<RecommendedItem>(size);
        for (int i = 0; i < size; ++i) {
            long itemID = Varint.readSignedVarLong(in);
            float value = in.readFloat();
            GenericRecommendedItem recommendedItem = new GenericRecommendedItem(itemID, value);
            this.recommended.add(recommendedItem);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append('[');
        boolean first = true;
        for (RecommendedItem item : this.recommended) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(String.valueOf(item.getItemID()));
            result.append(':');
            result.append(String.valueOf(item.getValue()));
        }
        result.append(']');
        return result.toString();
    }
}

