/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.map.OpenIntIntHashMap;

public class MaybePruneRowsMapper
extends Mapper<VarLongWritable, VectorWritable, IntWritable, DistributedRowMatrix.MatrixEntryWritable> {
    public static final String MAX_COOCCURRENCES = MaybePruneRowsMapper.class.getName() + ".maxCooccurrences";
    private int maxCooccurrences;
    private final OpenIntIntHashMap indexCounts = new OpenIntIntHashMap();

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        super.setup(ctx);
        this.maxCooccurrences = ctx.getConfiguration().getInt(MAX_COOCCURRENCES, -1);
        if (this.maxCooccurrences < 1) {
            throw new IllegalStateException("Maximum number of cooccurrences was not correctly set!");
        }
    }

    protected void map(VarLongWritable rowIndex, VectorWritable vectorWritable, Mapper.Context ctx) throws IOException, InterruptedException {
        Vector vector = vectorWritable.get();
        this.countSeen(vector);
        int numElementsBeforePruning = vector.getNumNondefaultElements();
        vector = this.maybePruneVector(vector);
        int numElementsAfterPruning = vector.getNumNondefaultElements();
        ctx.getCounter((Enum)Elements.USED).increment((long)numElementsAfterPruning);
        ctx.getCounter((Enum)Elements.NEGLECTED).increment((long)(numElementsBeforePruning - numElementsAfterPruning));
        DistributedRowMatrix.MatrixEntryWritable entry = new DistributedRowMatrix.MatrixEntryWritable();
        int colIndex = TasteHadoopUtils.idToIndex(rowIndex.get());
        entry.setCol(colIndex);
        Iterator iterator = vector.iterateNonZero();
        while (iterator.hasNext()) {
            Vector.Element elem = (Vector.Element)iterator.next();
            entry.setRow(elem.index());
            entry.setVal(elem.get());
            ctx.write((Object)new IntWritable(elem.index()), (Object)entry);
        }
    }

    private void countSeen(Vector vector) {
        Iterator it = vector.iterateNonZero();
        while (it.hasNext()) {
            int index = ((Vector.Element)it.next()).index();
            this.indexCounts.adjustOrPutValue(index, 1, 1);
        }
    }

    private Vector maybePruneVector(Vector vector) {
        if (vector.getNumNondefaultElements() <= this.maxCooccurrences) {
            return vector;
        }
        PriorityQueue smallCounts = new PriorityQueue(this.maxCooccurrences + 1, Collections.reverseOrder());
        Iterator it = vector.iterateNonZero();
        while (it.hasNext()) {
            int count = this.indexCounts.get(((Vector.Element)it.next()).index());
            if (smallCounts.size() < this.maxCooccurrences) {
                smallCounts.add(count);
                continue;
            }
            if (count >= (Integer)smallCounts.peek()) continue;
            smallCounts.add(count);
            smallCounts.poll();
        }
        int greatestSmallCount = (Integer)smallCounts.peek();
        if (greatestSmallCount > 0) {
            Iterator it2 = vector.iterateNonZero();
            while (it2.hasNext()) {
                Vector.Element e = (Vector.Element)it2.next();
                if (this.indexCounts.get(e.index()) <= greatestSmallCount) continue;
                e.set(0.0);
            }
        }
        return vector;
    }

    static enum Elements {
        USED,
        NEGLECTED;

    }
}

