/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Varint;

public final class EntityCountWritable
extends VarLongWritable {
    private int count;

    public EntityCountWritable() {
    }

    public EntityCountWritable(long itemID, int count) {
        super(itemID);
        this.count = count;
    }

    public EntityCountWritable(EntityCountWritable other) {
        this(other.get(), other.getCount());
    }

    public long getID() {
        return this.get();
    }

    public int getCount() {
        return this.count;
    }

    public void set(long id, int count) {
        super.set(id);
        this.count = count;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Varint.writeUnsignedVarInt(this.count, out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.count = Varint.readUnsignedVarInt(in);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.count;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EntityCountWritable)) {
            return false;
        }
        EntityCountWritable other = (EntityCountWritable)o;
        return this.get() == other.get() && this.count == other.getCount();
    }

    @Override
    public String toString() {
        return this.get() + "\t" + this.count;
    }

    @Override
    public EntityCountWritable clone() {
        return new EntityCountWritable(this.get(), this.count);
    }
}

