/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class RawLocalFileSystem
extends FileSystem {
    static final URI NAME = URI.create("file:///");
    private Path workingDir = new Path(System.getProperty("user.dir")).makeQualified(this);

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public File pathToFile(Path path) {
        this.checkPath(path);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    @Override
    public URI getUri() {
        return NAME;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (!this.exists(f)) {
            throw new FileNotFoundException(f.toString());
        }
        return new FSDataInputStream(new BufferedFSInputStream(new LocalFSFileInputStream(f), bufferSize));
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        if (!this.exists(f)) {
            throw new FileNotFoundException("File " + f + " not found.");
        }
        if (this.getFileStatus(f).isDir()) {
            throw new IOException("Cannot append to a diretory (=" + f + " ).");
        }
        return new FSDataOutputStream(new BufferedOutputStream(new LocalFSFileOutputStream(f, true), bufferSize), this.statistics);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new IOException("File already exists:" + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream(new BufferedOutputStream(new LocalFSFileOutputStream(f, false), bufferSize), this.statistics);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        this.setPermission(f, permission);
        return out;
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        if (this.pathToFile(src).renameTo(this.pathToFile(dst))) {
            return true;
        }
        return FileUtil.copy(this, src, this, dst, true, this.getConf());
    }

    @Override
    @Deprecated
    public boolean delete(Path p) throws IOException {
        return this.delete(p, true);
    }

    @Override
    public boolean delete(Path p, boolean recursive) throws IOException {
        File f = this.pathToFile(p);
        if (f.isFile()) {
            return f.delete();
        }
        if (!recursive && f.isDirectory() && f.listFiles().length != 0) {
            throw new IOException("Directory " + f.toString() + " is not empty");
        }
        return FileUtil.fullyDelete(f);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            return null;
        }
        if (localf.isFile()) {
            return new FileStatus[]{new RawLocalFileStatus(localf, this.getDefaultBlockSize(), this)};
        }
        String[] names = localf.list();
        if (names == null) {
            return null;
        }
        FileStatus[] results = new FileStatus[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.getFileStatus(new Path(f, names[i]));
        }
        return results;
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        Path parent = f.getParent();
        File p2f = this.pathToFile(f);
        return !(parent != null && !this.mkdirs(parent) || !p2f.mkdir() && !p2f.isDirectory());
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        boolean b = this.mkdirs(f);
        this.setPermission(f, permission);
        return b;
    }

    @Override
    public Path getHomeDirectory() {
        return new Path(System.getProperty("user.home")).makeQualified(this);
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeAbsolute(newDir);
        this.checkPath(this.workingDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        File partition = this.pathToFile(p == null ? new Path("/") : p);
        return new FsStatus(partition.getTotalSpace(), partition.getTotalSpace() - partition.getFreeSpace(), partition.getFreeSpace());
    }

    @Override
    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.rename(src, dst);
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return fsOutputFile;
    }

    @Override
    public void completeLocalOutput(Path fsWorkingFile, Path tmpLocalFile) throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "LocalFS";
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new RawLocalFileStatus(this.pathToFile(f), this.getDefaultBlockSize(), this);
        }
        throw new FileNotFoundException("File " + f + " does not exist.");
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        if (username == null) {
            RawLocalFileSystem.execCommand(this.pathToFile(p), "chgrp", groupname);
        } else {
            String s = username + (groupname == null ? "" : ":" + groupname);
            RawLocalFileSystem.execCommand(this.pathToFile(p), "chown", s);
        }
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        if (NativeIO.isAvailable()) {
            NativeIO.chmod(this.pathToFile(p).getCanonicalPath(), permission.toShort());
        } else {
            RawLocalFileSystem.execCommand(this.pathToFile(p), "chmod", String.format("%05o", permission.toShort()));
        }
    }

    private static String execCommand(File f, String ... cmd) throws IOException {
        String[] args = new String[cmd.length + 1];
        System.arraycopy(cmd, 0, args, 0, cmd.length);
        args[cmd.length] = f.getCanonicalPath();
        String output = Shell.execCommand(args);
        return output;
    }

    static class RawLocalFileStatus
    extends FileStatus {
        private boolean isPermissionLoaded() {
            return !super.getOwner().equals("");
        }

        RawLocalFileStatus(File f, long defaultBlockSize, FileSystem fs) {
            super(f.length(), f.isDirectory(), 1, defaultBlockSize, f.lastModified(), new Path(f.getPath()).makeQualified(fs));
        }

        @Override
        public FsPermission getPermission() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getPermission();
        }

        @Override
        public String getOwner() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getOwner();
        }

        @Override
        public String getGroup() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPermissionInfo() {
            block9: {
                IOException e = null;
                try {
                    StringTokenizer t = new StringTokenizer(RawLocalFileSystem.execCommand(new File(this.getPath().toUri()), Shell.getGET_PERMISSION_COMMAND()));
                    String permission = t.nextToken();
                    if (permission.length() > 10) {
                        permission = permission.substring(0, 10);
                    }
                    this.setPermission(FsPermission.valueOf(permission));
                    t.nextToken();
                    this.setOwner(t.nextToken());
                    this.setGroup(t.nextToken());
                }
                catch (Shell.ExitCodeException ioe) {
                    if (ioe.getExitCode() != 1) {
                        e = ioe;
                    }
                    this.setPermission(null);
                    this.setOwner(null);
                    this.setGroup(null);
                }
                catch (IOException ioe) {
                    e = ioe;
                }
                finally {
                    if (e == null) break block9;
                    throw new RuntimeException("Error while running command to get file permissions : " + StringUtils.stringifyException(e));
                }
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            super.write(out);
        }
    }

    class LocalFSFileOutputStream
    extends OutputStream
    implements Syncable {
        FileOutputStream fos;

        private LocalFSFileOutputStream(Path f, boolean append) throws IOException {
            this.fos = new FileOutputStream(RawLocalFileSystem.this.pathToFile(f), append);
        }

        @Override
        public void close() throws IOException {
            this.fos.close();
        }

        @Override
        public void flush() throws IOException {
            this.fos.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fos.write(b, off, len);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.fos.write(b);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public void sync() throws IOException {
            this.fos.getFD().sync();
        }
    }

    class LocalFSFileInputStream
    extends FSInputStream {
        FileInputStream fis;
        private long position;

        public LocalFSFileInputStream(Path f) throws IOException {
            this.fis = new TrackingFileInputStream(RawLocalFileSystem.this.pathToFile(f));
        }

        @Override
        public void seek(long pos) throws IOException {
            this.fis.getChannel().position(pos);
            this.position = pos;
        }

        @Override
        public long getPos() throws IOException {
            return this.position;
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        @Override
        public int available() throws IOException {
            return this.fis.available();
        }

        @Override
        public void close() throws IOException {
            this.fis.close();
        }

        public boolean markSupport() {
            return false;
        }

        @Override
        public int read() throws IOException {
            try {
                int value = this.fis.read();
                if (value >= 0) {
                    ++this.position;
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int value = this.fis.read(b, off, len);
                if (value > 0) {
                    this.position += (long)value;
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public int read(long position, byte[] b, int off, int len) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            try {
                return this.fis.getChannel().read(bb, position);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            long value = this.fis.skip(n);
            if (value > 0L) {
                this.position += value;
            }
            return value;
        }
    }

    class TrackingFileInputStream
    extends FileInputStream {
        public TrackingFileInputStream(File f) throws IOException {
            super(f);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                RawLocalFileSystem.this.statistics.incrementBytesRead(1L);
            }
            return result;
        }

        @Override
        public int read(byte[] data) throws IOException {
            int result = super.read(data);
            if (result != -1) {
                RawLocalFileSystem.this.statistics.incrementBytesRead(result);
            }
            return result;
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            int result = super.read(data, offset, length);
            if (result != -1) {
                RawLocalFileSystem.this.statistics.incrementBytesRead(result);
            }
            return result;
        }
    }
}

