/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.SelectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TruncationSelection
implements SelectionStrategy<Object> {
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#0.###%");
    private final NumberGenerator<Double> selectionRatio;
    private String description = "Truncation Selection";

    public TruncationSelection(NumberGenerator<Double> selectionRatio) {
        this.selectionRatio = selectionRatio;
    }

    public TruncationSelection(double selectionRatio) {
        this(new ConstantGenerator<Double>(selectionRatio));
        if (selectionRatio <= 0.0 || selectionRatio >= 1.0) {
            throw new IllegalArgumentException("Selection ratio must be greater than 0 and less than 1.");
        }
        this.description = "Truncation Selection (" + PERCENT_FORMAT.format(selectionRatio) + ")";
    }

    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        ArrayList<S> selection = new ArrayList<S>(selectionSize);
        double ratio = this.selectionRatio.nextValue();
        assert (ratio < 1.0 && ratio > 0.0) : "Selection ratio out-of-range: " + ratio;
        int eligibleCount = (int)Math.round(ratio * (double)population.size());
        eligibleCount = eligibleCount > selectionSize ? selectionSize : eligibleCount;
        do {
            int count = Math.min(eligibleCount, selectionSize - selection.size());
            for (int i = 0; i < count; ++i) {
                selection.add(population.get(i).getCandidate());
            }
        } while (selection.size() < selectionSize);
        return selection;
    }

    public String toString() {
        return this.description;
    }
}

