/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.CandidateFactory;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replacement<T>
implements EvolutionaryOperator<T> {
    private final CandidateFactory<T> factory;
    private final NumberGenerator<Probability> replacementProbability;

    public Replacement(CandidateFactory<T> factory, Probability replacementProbability) {
        this(factory, new ConstantGenerator<Probability>(replacementProbability));
    }

    public Replacement(CandidateFactory<T> factory, NumberGenerator<Probability> replacementProbability) {
        this.factory = factory;
        this.replacementProbability = replacementProbability;
    }

    @Override
    public List<T> apply(List<T> selectedCandidates, Random rng) {
        ArrayList<T> output = new ArrayList<T>(selectedCandidates.size());
        for (T candidate : selectedCandidates) {
            output.add(this.replacementProbability.nextValue().nextEvent(rng) ? this.factory.generateRandomCandidate(rng) : candidate);
        }
        return output;
    }
}

