/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.ConstantGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOrderMutation<T>
implements EvolutionaryOperator<List<T>> {
    private final NumberGenerator<Integer> mutationCountVariable;
    private final NumberGenerator<Integer> mutationAmountVariable;

    public ListOrderMutation() {
        this(1, 1);
    }

    public ListOrderMutation(int mutationCount, int mutationAmount) {
        this(new ConstantGenerator<Integer>(mutationCount), new ConstantGenerator<Integer>(mutationAmount));
    }

    public ListOrderMutation(NumberGenerator<Integer> mutationCount, NumberGenerator<Integer> mutationAmount) {
        this.mutationCountVariable = mutationCount;
        this.mutationAmountVariable = mutationAmount;
    }

    @Override
    public List<List<T>> apply(List<List<T>> population, Random rng) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(population.size());
        for (List<T> candidate : population) {
            ArrayList<T> newCandidate = new ArrayList<T>(candidate);
            int mutationCount = Math.abs(this.mutationCountVariable.nextValue());
            for (int i = 0; i < mutationCount; ++i) {
                int mutationAmount;
                int fromIndex = rng.nextInt(newCandidate.size());
                int toIndex = (fromIndex + (mutationAmount = this.mutationAmountVariable.nextValue().intValue())) % newCandidate.size();
                if (toIndex < 0) {
                    toIndex += newCandidate.size();
                }
                Collections.swap(newCandidate, fromIndex, toIndex);
            }
            result.add(newCandidate);
        }
        return result;
    }
}

