/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.AbstractMatrix1D;
import org.apache.mahout.math.matrix.linalg.Property;

@Deprecated
public abstract class DoubleMatrix1D
extends AbstractMatrix1D
implements Cloneable {
    protected DoubleMatrix1D() {
    }

    public double aggregate(DoubleDoubleFunction aggr, DoubleFunction f) {
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(this.size - 1));
        int i = this.size - 1;
        while (--i >= 0) {
            a = aggr.apply(a, f.apply(this.getQuick(i)));
        }
        return a;
    }

    public double aggregate(DoubleMatrix1D other, DoubleDoubleFunction aggr, DoubleDoubleFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            return Double.NaN;
        }
        double a = f.apply(this.getQuick(this.size - 1), other.getQuick(this.size - 1));
        int i = this.size - 1;
        while (--i >= 0) {
            a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
        }
        return a;
    }

    public void assign(double[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, values[i]);
        }
    }

    public void assign(double value) {
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, value);
        }
    }

    public void assign(DoubleFunction function) {
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, function.apply(this.getQuick(i)));
        }
    }

    public DoubleMatrix1D assign(DoubleMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.haveSharedCells(other)) {
            other = other.copy();
        }
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, other.getQuick(i));
        }
        return this;
    }

    public Vector toVector() {
        DenseVector vector = new DenseVector(this.cardinality());
        for (int i = 0; i < this.cardinality(); ++i) {
            vector.set(i, this.get(i));
        }
        return vector;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D y, DoubleDoubleFunction function) {
        this.checkSize(y);
        int i = this.size;
        while (--i >= 0) {
            this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
        }
        return this;
    }

    public void assign(DoubleMatrix1D y, DoubleDoubleFunction function, IntArrayList nonZeroIndexes) {
        this.checkSize(y);
        int[] nonZeroElements = nonZeroIndexes.elements();
        if (function == Functions.MULT) {
            int j = 0;
            int index = nonZeroIndexes.size();
            while (--index >= 0) {
                int i = nonZeroElements[index];
                while (j < i) {
                    this.setQuick(j, 0.0);
                    ++j;
                }
                this.setQuick(i, this.getQuick(i) * y.getQuick(i));
                ++j;
            }
        } else if (function instanceof PlusMult) {
            double multiplicator = ((PlusMult)function).getMultiplicator();
            if (multiplicator != 0.0) {
                if (multiplicator == 1.0) {
                    int index = nonZeroIndexes.size();
                    while (--index >= 0) {
                        int i = nonZeroElements[index];
                        this.setQuick(i, this.getQuick(i) + y.getQuick(i));
                    }
                } else if (multiplicator == -1.0) {
                    int index = nonZeroIndexes.size();
                    while (--index >= 0) {
                        int i = nonZeroElements[index];
                        this.setQuick(i, this.getQuick(i) - y.getQuick(i));
                    }
                } else {
                    int index = nonZeroIndexes.size();
                    while (--index >= 0) {
                        int i = nonZeroElements[index];
                        this.setQuick(i, this.getQuick(i) + multiplicator * y.getQuick(i));
                    }
                }
            }
        } else {
            this.assign(y, function);
        }
    }

    public int cardinality() {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0) {
            if (this.getQuick(i) == 0.0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (this.getQuick(i) == 0.0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public DoubleMatrix1D copy() {
        DoubleMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public boolean equals(double value) {
        return Property.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleMatrix1D)) {
            return false;
        }
        return Property.DEFAULT.equals(this, (DoubleMatrix1D)obj);
    }

    public double get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    protected DoubleMatrix1D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        for (int i = 0; i < s; ++i) {
            double value = this.getQuick(i);
            if (value == 0.0) continue;
            if (fillIndexList) {
                indexList.add(i);
            }
            if (!fillValueList) continue;
            valueList.add(value);
        }
    }

    public void getNonZeros(IntArrayList indexList, DoubleArrayList valueList, int maxCardinality) {
        boolean fillIndexList = indexList != null;
        boolean fillValueList = valueList != null;
        int card = this.cardinality(maxCardinality);
        if (fillIndexList) {
            indexList.setSize(card);
        }
        if (fillValueList) {
            valueList.setSize(card);
        }
        if (card >= maxCardinality) {
            return;
        }
        if (fillIndexList) {
            indexList.setSize(0);
        }
        if (fillValueList) {
            valueList.setSize(0);
        }
        int s = this.size;
        for (int i = 0; i < s; ++i) {
            double value = this.getQuick(i);
            if (value == 0.0) continue;
            if (fillIndexList) {
                indexList.add(i);
            }
            if (!fillValueList) continue;
            valueList.add(value);
        }
    }

    public abstract double getQuick(int var1);

    protected boolean haveSharedCells(DoubleMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        return false;
    }

    public DoubleMatrix1D like() {
        return this.like(this.size);
    }

    public abstract DoubleMatrix1D like(int var1);

    public abstract DoubleMatrix2D like2D(int var1, int var2);

    public void set(int index, double value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, double var2);

    public void swap(DoubleMatrix1D other) {
        this.checkSize(other);
        int i = this.size;
        while (--i >= 0) {
            double tmp = this.getQuick(i);
            this.setQuick(i, other.getQuick(i));
            other.setQuick(i, tmp);
        }
    }

    public double[] toArray() {
        double[] values = new double[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(double[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int i = this.size;
        while (--i >= 0) {
            values[i] = this.getQuick(i);
        }
    }

    protected DoubleMatrix1D view() {
        try {
            return (DoubleMatrix1D)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public DoubleMatrix1D viewPart(int index, int width) {
        return (DoubleMatrix1D)this.view().vPart(index, width);
    }

    protected abstract DoubleMatrix1D viewSelectionLike(int[] var1);

    public double zDotProduct(DoubleMatrix1D y) {
        return this.zDotProduct(y, 0, this.size);
    }

    public double zDotProduct(DoubleMatrix1D y, int from, int length) {
        if (from < 0 || length <= 0) {
            return 0.0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        double sum = 0.0;
        int i = tail - 1;
        int k = length;
        while (--k >= 0) {
            sum += this.getQuick(i) * y.getQuick(i);
            --i;
        }
        return sum;
    }

    public double zDotProduct(DoubleMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        int index;
        if (from < 0 || length <= 0) {
            return 0.0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return 0.0;
        }
        int[] nonZeroIndexElements = nonZeroIndexes.elements();
        int s = nonZeroIndexes.size();
        for (index = 0; index < s && nonZeroIndexElements[index] < from; ++index) {
        }
        double sum = 0.0;
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            sum += this.getQuick(i) * y.getQuick(i);
            ++index;
        }
        return sum;
    }

    protected double zDotProduct(DoubleMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, this.size, nonZeroIndexes);
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(Functions.PLUS, Functions.IDENTITY);
    }
}

