/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat;

import org.apache.mahout.math.jet.random.Normal;
import org.apache.mahout.math.jet.stat.Gamma;

public final class Probability {
    private static final Normal UNIT_NORMAL = new Normal(0.0, 1.0, null);

    private Probability() {
    }

    public static double beta(double a, double b, double x) {
        return Gamma.incompleteBeta(a, b, x);
    }

    public static double gamma(double alpha, double beta, double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Gamma.incompleteGamma(alpha, beta * x);
    }

    public static double negativeBinomial(int k, int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0) {
            return 0.0;
        }
        return Gamma.incompleteBeta(n, k + 1, p);
    }

    public static double normal(double a) {
        if (a < 0.0) {
            return 1.0 - Probability.normal(-a);
        }
        double b0 = 0.2316419;
        double b1 = 0.31938153;
        double b2 = -0.356563782;
        double b3 = 1.781477937;
        double b4 = -1.821255978;
        double b5 = 1.330274429;
        double t = 1.0 / (1.0 + b0 * a);
        return 1.0 - UNIT_NORMAL.pdf(a) * t * (b1 + t * (b2 + t * (b3 + t * (b4 + t * b5))));
    }

    public static double normal(double mean, double variance, double x) {
        return Probability.normal((x - mean) / Math.sqrt(variance));
    }

    public static double poisson(int k, double mean) {
        if (mean < 0.0) {
            throw new IllegalArgumentException();
        }
        if (k < 0) {
            return 0.0;
        }
        return Gamma.incompleteGammaComplement(k + 1, mean);
    }
}

