/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;

public class Uniform
extends AbstractContinousDistribution {
    private double min;
    private double max;

    public Uniform(double min, double max, int seed) {
        this(min, max, RandomUtils.getRandom(seed));
    }

    public Uniform(double min, double max, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(min, max);
    }

    public Uniform(Random randomGenerator) {
        this(0.0, 1.0, randomGenerator);
    }

    @Override
    public double cdf(double x) {
        if (x <= this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        return (x - this.min) / (this.max - this.min);
    }

    public boolean nextBoolean() {
        return this.randomGenerator.nextDouble() > 0.5;
    }

    @Override
    public double nextDouble() {
        return this.min + (this.max - this.min) * this.randomGenerator.nextDouble();
    }

    public double nextDoubleFromTo(double from, double to) {
        return from + (to - from) * this.randomGenerator.nextDouble();
    }

    public float nextFloatFromTo(float from, float to) {
        return (float)this.nextDoubleFromTo(from, to);
    }

    public int nextIntFromTo(int from, int to) {
        return (int)((long)from + (long)((double)(1L + (long)to - (long)from) * this.randomGenerator.nextDouble()));
    }

    public long nextLongFromTo(long from, long to) {
        long random;
        if (from >= 0L && to < Long.MAX_VALUE) {
            return from + (long)this.nextDoubleFromTo(0.0, to - from + 1L);
        }
        double diff = (double)to - (double)from + 1.0;
        if (diff <= 9.223372036854776E18) {
            return from + (long)this.nextDoubleFromTo(0.0, diff);
        }
        if (from == Long.MIN_VALUE) {
            if (to == Long.MAX_VALUE) {
                int i1 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                int i2 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return ((long)i1 & 0xFFFFFFFFL) << 32 | (long)i2 & 0xFFFFFFFFL;
            }
            random = Math.round(this.nextDoubleFromTo(from, to + 1L));
            if (random > to) {
                random = from;
            }
        } else {
            random = Math.round(this.nextDoubleFromTo(from - 1L, to));
            if (random < from) {
                random = to;
            }
        }
        return random;
    }

    @Override
    public double pdf(double x) {
        if (x <= this.min || x >= this.max) {
            return 0.0;
        }
        return 1.0 / (this.max - this.min);
    }

    public void setState(double min, double max) {
        if (max < min) {
            this.setState(max, min);
            return;
        }
        this.min = min;
        this.max = max;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.min + ',' + this.max + ')';
    }
}

